/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.AvailabilityZone;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.services.InstanceClient;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class EC2Utils {
    private static final Pattern ELB_PATTERN = Pattern.compile("([^.]+)-[^.]+\\.([^.]+)\\.elb\\.amazonaws\\.com");

    public static String[] getAvailabilityZonesForRegion(String region) {
        HashSet<String> availabilityZones = new HashSet<String>();
        for (String az : AvailabilityZone.zones) {
            if (!az.startsWith(region)) continue;
            availabilityZones.add(az);
        }
        return availabilityZones.toArray(new String[availabilityZones.size()]);
    }

    public static void indexStringArrayToFormValuesWithPrefix(HttpRequest request, String prefix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof String[]), (Object)("this binder is only valid for String[] : " + input.getClass()));
        String[] values = (String[])input;
        for (int i = 0; i < values.length; ++i) {
            HttpUtils.addFormParamTo((HttpRequest)request, (String)(prefix + "." + (i + 1)), (String)((String)Preconditions.checkNotNull((Object)values[i], (Object)(prefix.toLowerCase() + "s[" + i + "]"))));
        }
    }

    public static Iterable<RunningInstance> getAllRunningInstancesInRegion(InstanceClient client, String region, String id) {
        return Iterables.concat(client.describeInstancesInRegion(region, id));
    }

    public static String[] parseHandle(String id) {
        String[] parts = ((String)Preconditions.checkNotNull((Object)id, (Object)"id")).split("/");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)"id syntax is region/instanceid");
        return parts;
    }

    public static void indexIterableToFormValuesWithPrefix(HttpRequest request, String prefix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)("this binder is only valid for Iterable<?>: " + input.getClass()));
        Iterable values = (Iterable)input;
        int i = 0;
        for (Object o : values) {
            HttpUtils.addFormParamTo((HttpRequest)request, (String)(prefix + "." + (i++ + 1)), (String)((String)Preconditions.checkNotNull((Object)o.toString(), (Object)(prefix.toLowerCase() + "s[" + i + "]"))));
        }
    }

    public static String findRegionInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            String regionName;
            if (!(arg instanceof String) || !EC2Utils.isRegion(regionName = (String)arg)) continue;
            return regionName;
        }
        return null;
    }

    public static boolean isRegion(String regionName) {
        return "eu-west-1".equals(regionName) || "us-west-1".equals(regionName) || "us-east-1".equals(regionName) || "us-standard".equals(regionName) || "ap-southeast-1".equals(regionName);
    }

    public static String findAvailabilityZoneInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            String zone;
            if (!(arg instanceof String) || !AvailabilityZone.zones.contains(zone = (String)arg)) continue;
            return zone;
        }
        return null;
    }

    public static void indexStringArrayToFormValuesWithStringFormat(HttpRequest request, String format, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof String[]), (Object)("this binder is only valid for String[] : " + input.getClass()));
        String[] values = (String[])input;
        for (int i = 0; i < values.length; ++i) {
            HttpUtils.addFormParamTo((HttpRequest)request, (String)String.format(format, i + 1), (String)((String)Preconditions.checkNotNull((Object)values[i], (Object)(format.toLowerCase() + "s[" + i + "]"))));
        }
    }

    public static Map<String, String> getLoadBalancerNameAndRegionFromDnsName(String dnsName) {
        Matcher matcher = ELB_PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)dnsName, (Object)"dnsName"));
        Preconditions.checkArgument((boolean)matcher.find(), (Object)("dnsName syntax is " + ELB_PATTERN + " didn't match: " + dnsName));
        String loadBalancerName = matcher.group(1);
        String regionName = matcher.group(2);
        Preconditions.checkArgument((boolean)EC2Utils.isRegion(regionName), (Object)String.format("Region (%s)  parsed from (%s) is not a valid region", regionName, dnsName));
        return ImmutableMap.of((Object)regionName, (Object)loadBalancerName);
    }

    @Singleton
    public static class GetRegionFromLocation
    implements Function<Location, String> {
        public String apply(Location location) {
            String region = location.getScope() == LocationScope.REGION ? location.getId() : location.getParent().getId();
            return region;
        }
    }
}

