/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.binders.BindS3UploadPolicyAndSignature;
import org.jclouds.aws.ec2.domain.BundleTask;
import org.jclouds.aws.ec2.options.BundleInstanceS3StorageOptions;
import org.jclouds.aws.ec2.xml.BundleTaskHandler;
import org.jclouds.aws.ec2.xml.DescribeBundleTasksResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2010-06-15"})
@VirtualHost
public interface WindowsAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"BundleInstance"})
    @XMLResponseParser(value=BundleTaskHandler.class)
    public ListenableFuture<BundleTask> bundleInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Storage.S3.Prefix") String var3, @FormParam(value="Storage.S3.Bucket") String var4, @BinderParam(value=BindS3UploadPolicyAndSignature.class) String var5, BundleInstanceS3StorageOptions ... var6);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CancelBundleTask"})
    @XMLResponseParser(value=BundleTaskHandler.class)
    public ListenableFuture<BundleTask> cancelBundleTaskInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="BundleId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeBundleTasks"})
    @XMLResponseParser(value=DescribeBundleTasksResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<BundleTask>> describeBundleTasksInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);
}

