/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.xml.DescribeKeyPairsResponseHandler;
import org.jclouds.aws.ec2.xml.KeyPairResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2010-06-15"})
@VirtualHost
public interface KeyPairAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateKeyPair"})
    @XMLResponseParser(value=KeyPairResponseHandler.class)
    public ListenableFuture<KeyPair> createKeyPairInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="KeyName") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeKeyPairs"})
    @XMLResponseParser(value=DescribeKeyPairsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<KeyPair>> describeKeyPairsInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteKeyPair"})
    public ListenableFuture<Void> deleteKeyPairInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="KeyName") String var2);
}

