/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.binders.BindBlockDeviceMappingToIndexedFormParams;
import org.jclouds.aws.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.aws.ec2.domain.BlockDeviceMapping;
import org.jclouds.aws.ec2.domain.InstanceStateChange;
import org.jclouds.aws.ec2.domain.Reservation;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.domain.Volume;
import org.jclouds.aws.ec2.functions.ConvertUnencodedBytesToBase64EncodedString;
import org.jclouds.aws.ec2.options.RunInstancesOptions;
import org.jclouds.aws.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.aws.ec2.xml.BooleanValueHandler;
import org.jclouds.aws.ec2.xml.DescribeInstancesResponseHandler;
import org.jclouds.aws.ec2.xml.InstanceInitiatedShutdownBehaviorHandler;
import org.jclouds.aws.ec2.xml.InstanceStateChangeHandler;
import org.jclouds.aws.ec2.xml.InstanceTypeHandler;
import org.jclouds.aws.ec2.xml.RunInstancesResponseHandler;
import org.jclouds.aws.ec2.xml.StringValueHandler;
import org.jclouds.aws.ec2.xml.UnencodeStringValueHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2010-06-15"})
@VirtualHost
public interface InstanceAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=DescribeInstancesResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<? extends Reservation<? extends RunningInstance>>> describeInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RunInstances"})
    @XMLResponseParser(value=RunInstancesResponseHandler.class)
    public ListenableFuture<Reservation<? extends RunningInstance>> runInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @Nullable @BinderParam(value=IfNotNullBindAvailabilityZoneToFormParam.class) String var2, @FormParam(value="ImageId") String var3, @FormParam(value="MinCount") int var4, @FormParam(value="MaxCount") int var5, RunInstancesOptions ... var6);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RebootInstances"})
    public ListenableFuture<Void> rebootInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"TerminateInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> terminateInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StopInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> stopInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="Force") boolean var2, String ... var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StartInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> startInstancesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "userData"})
    @XMLResponseParser(value=UnencodeStringValueHandler.class)
    public ListenableFuture<String> getUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "rootDeviceName"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getRootDeviceNameForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "ramdisk"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "kernel"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "disableApiTermination"})
    @XMLResponseParser(value=BooleanValueHandler.class)
    public ListenableFuture<Boolean> isApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceType"})
    @XMLResponseParser(value=InstanceTypeHandler.class)
    public ListenableFuture<String> getInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    @XMLResponseParser(value=InstanceInitiatedShutdownBehaviorHandler.class)
    public ListenableFuture<Volume.InstanceInitiatedShutdownBehavior> getInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "blockDeviceMapping"})
    @XMLResponseParser(value=BlockDeviceMappingHandler.class)
    public ListenableFuture<? extends Map<String, RunningInstance.EbsBlockDevice>> getBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "ramdisk"})
    public ListenableFuture<Void> resetRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "kernel"})
    public ListenableFuture<Void> resetKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "userData"})
    public ListenableFuture<Void> setUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") @ParamParser(value=ConvertUnencodedBytesToBase64EncodedString.class) byte[] var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "ramdisk"})
    public ListenableFuture<Void> setRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "kernel"})
    public ListenableFuture<Void> setKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "disableApiTermination"})
    public ListenableFuture<Void> setApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") boolean var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceType"})
    public ListenableFuture<Void> setInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    public ListenableFuture<Void> setInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") Volume.InstanceInitiatedShutdownBehavior var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ModifyInstanceAttribute"})
    public ListenableFuture<Void> setBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @BinderParam(value=BindBlockDeviceMappingToIndexedFormParams.class) BlockDeviceMapping var3);
}

