/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.binders.BindUserGroupsToIndexedFormParams;
import org.jclouds.aws.ec2.binders.BindUserIdsToIndexedFormParams;
import org.jclouds.aws.ec2.domain.Attachment;
import org.jclouds.aws.ec2.domain.Permission;
import org.jclouds.aws.ec2.domain.Snapshot;
import org.jclouds.aws.ec2.domain.Volume;
import org.jclouds.aws.ec2.functions.AvailabilityZoneToEndpoint;
import org.jclouds.aws.ec2.functions.ReturnVoidOnVolumeAvailable;
import org.jclouds.aws.ec2.options.CreateSnapshotOptions;
import org.jclouds.aws.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.aws.ec2.options.DetachVolumeOptions;
import org.jclouds.aws.ec2.xml.AttachmentHandler;
import org.jclouds.aws.ec2.xml.CreateVolumeResponseHandler;
import org.jclouds.aws.ec2.xml.DescribeSnapshotsResponseHandler;
import org.jclouds.aws.ec2.xml.DescribeVolumesResponseHandler;
import org.jclouds.aws.ec2.xml.PermissionHandler;
import org.jclouds.aws.ec2.xml.SnapshotHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2010-06-15"})
@VirtualHost
public interface ElasticBlockStoreAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public ListenableFuture<Volume> createVolumeFromSnapshotInAvailabilityZone(@EndpointParam(parser=AvailabilityZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="SnapshotId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public ListenableFuture<Volume> createVolumeFromSnapshotInAvailabilityZone(@EndpointParam(parser=AvailabilityZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="Size") int var2, @FormParam(value="SnapshotId") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public ListenableFuture<Volume> createVolumeInAvailabilityZone(@EndpointParam(parser=AvailabilityZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="Size") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeVolumes"})
    @XMLResponseParser(value=DescribeVolumesResponseHandler.class)
    public ListenableFuture<? extends Set<Volume>> describeVolumesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteVolume"})
    public ListenableFuture<Void> deleteVolumeInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="VolumeId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DetachVolume"})
    @ExceptionParser(value=ReturnVoidOnVolumeAvailable.class)
    public ListenableFuture<Void> detachVolumeInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, @FormParam(value="Force") boolean var3, DetachVolumeOptions ... var4);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AttachVolume"})
    @XMLResponseParser(value=AttachmentHandler.class)
    public ListenableFuture<Attachment> attachVolumeInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, @FormParam(value="InstanceId") String var3, @FormParam(value="Device") String var4);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateSnapshot"})
    @XMLResponseParser(value=SnapshotHandler.class)
    public ListenableFuture<Snapshot> createSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, CreateSnapshotOptions ... var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSnapshots"})
    @XMLResponseParser(value=DescribeSnapshotsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<Snapshot>> describeSnapshotsInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, DescribeSnapshotsOptions ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSnapshot"})
    public ListenableFuture<Void> deleteSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifySnapshotAttribute", "add", "createVolumePermission"})
    public ListenableFuture<Void> addCreateVolumePermissionsToSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="SnapshotId") String var4);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifySnapshotAttribute", "remove", "createVolumePermission"})
    public ListenableFuture<Void> removeCreateVolumePermissionsFromSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="SnapshotId") String var4);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeSnapshotAttribute", "createVolumePermission"})
    @XMLResponseParser(value=PermissionHandler.class)
    public ListenableFuture<Permission> getCreateVolumePermissionForSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetSnapshotAttribute", "createVolumePermission"})
    public ListenableFuture<Void> resetCreateVolumePermissionsOnSnapshotInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);
}

