/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.Volume;
import org.jclouds.aws.ec2.services.ElasticBlockStoreClient;
import org.jclouds.logging.Logger;

@Singleton
public class VolumeAvailable
implements Predicate<Volume> {
    private final ElasticBlockStoreClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VolumeAvailable(ElasticBlockStoreClient client) {
        this.client = client;
    }

    public boolean apply(Volume volume) {
        this.logger.trace("looking for status on volume %s", new Object[]{volume.getId()});
        volume = (Volume)Iterables.getOnlyElement(this.client.describeVolumesInRegion(volume.getRegion(), volume.getId()));
        this.logger.trace("%s: looking for status %s: currently: %s", new Object[]{volume, Volume.Status.AVAILABLE, volume.getStatus()});
        return volume.getStatus() == Volume.Status.AVAILABLE;
    }
}

