/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class PlacementGroupAvailable
implements Predicate<PlacementGroup> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public PlacementGroupAvailable(EC2Client client) {
        this.client = client;
    }

    public boolean apply(PlacementGroup group) {
        this.logger.trace("looking for state on group %s", new Object[]{group});
        try {
            group = this.refresh(group);
            this.logger.trace("%s: looking for group state %s: currently: %s", new Object[]{group.getName(), PlacementGroup.State.AVAILABLE, group.getState()});
            return group.getState() == PlacementGroup.State.AVAILABLE;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private PlacementGroup refresh(PlacementGroup group) {
        return (PlacementGroup)Iterables.getOnlyElement(this.client.getPlacementGroupServices().describePlacementGroupsInRegion(group.getRegion(), group.getName()));
    }
}

