/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.domain.InstanceState;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class InstanceStateRunning
implements Predicate<RunningInstance> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstanceStateRunning(EC2Client client) {
        this.client = client;
    }

    public boolean apply(RunningInstance instance) {
        this.logger.trace("looking for state on instance %s", new Object[]{instance});
        try {
            instance = this.refresh(instance);
            this.logger.trace("%s: looking for instance state %s: currently: %s", new Object[]{instance.getId(), InstanceState.RUNNING, instance.getInstanceState()});
            return instance.getInstanceState() == InstanceState.RUNNING;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    private RunningInstance refresh(RunningInstance instance) {
        return (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement(this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), instance.getId()))));
    }
}

