/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class InstancePresent
implements Predicate<RunningInstance> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstancePresent(EC2Client client) {
        this.client = client;
    }

    public boolean apply(RunningInstance instance) {
        this.logger.trace("looking for instance %s", new Object[]{instance});
        try {
            instance = this.refresh(instance);
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private RunningInstance refresh(RunningInstance instance) {
        return (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement(this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), instance.getId()))));
    }
}

