/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class BaseEC2RequestOptions
extends BaseHttpRequestOptions {
    protected void indexFormValuesWithPrefix(String prefix, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.formParameters.put((Object)(prefix + "." + (i + 1)), Preconditions.checkNotNull((Object)values[i], (Object)(prefix.toLowerCase() + "s[" + i + "]")));
        }
    }

    protected void indexFormValuesWithPrefix(String prefix, Iterable<String> values) {
        this.indexFormValuesWithPrefix(prefix, (String[])Iterables.toArray(values, String.class));
    }

    protected Set<String> getFormValuesWithKeysPrefixedBy(final String prefix) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        for (String key : Iterables.filter((Iterable)this.formParameters.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(prefix);
            }
        })) {
            values.add(this.formParameters.get((Object)key).iterator().next());
        }
        return values;
    }
}

