/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.aws.ec2.options.internal.BaseEC2RequestOptions;
import org.jclouds.encryption.internal.Base64;

public class RunInstancesOptions
extends BaseEC2RequestOptions {
    public static final RunInstancesOptions NONE = new RunInstancesOptions();

    public RunInstancesOptions withKeyName(String keyName) {
        this.formParameters.put((Object)"KeyName", Preconditions.checkNotNull((Object)keyName, (Object)"keyName"));
        return this;
    }

    String getKeyName() {
        return this.getFirstFormOrNull("KeyName");
    }

    public RunInstancesOptions withSecurityGroups(String ... securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroups(Iterable<String> securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroup(String securityGroup) {
        return this.withSecurityGroups(securityGroup);
    }

    String getSecurityGroup() {
        return this.getFirstFormOrNull("SecurityGroup.1");
    }

    public RunInstancesOptions inPlacementGroup(String placementGroup) {
        this.formParameters.put((Object)"Placement.GroupName", Preconditions.checkNotNull((Object)placementGroup, (Object)"placementGroup"));
        return this;
    }

    String getPlacementGroup() {
        return this.getFirstFormOrNull("Placement.GroupName");
    }

    public RunInstancesOptions withAdditionalInfo(String info) {
        this.formParameters.put((Object)"AdditionalInfo", Preconditions.checkNotNull((Object)info, (Object)"info"));
        return this;
    }

    String getAdditionalInfo() {
        return this.getFirstFormOrNull("AdditionalInfo");
    }

    public RunInstancesOptions withUserData(byte[] unencodedData) {
        Preconditions.checkArgument((((byte[])Preconditions.checkNotNull((Object)unencodedData, (Object)"unencodedData")).length <= 16384 ? 1 : 0) != 0, (Object)"userData cannot be larger than 16kb");
        this.formParameters.put((Object)"UserData", (Object)Base64.encodeBytes((byte[])unencodedData));
        return this;
    }

    String getUserData() {
        return this.getFirstFormOrNull("UserData");
    }

    public RunInstancesOptions asType(String type) {
        this.formParameters.put((Object)"InstanceType", Preconditions.checkNotNull((Object)type, (Object)"type"));
        return this;
    }

    String getType() {
        return this.getFirstFormOrNull("InstanceType");
    }

    public RunInstancesOptions withKernelId(String kernelId) {
        this.formParameters.put((Object)"KernelId", Preconditions.checkNotNull((Object)kernelId, (Object)"kernelId"));
        return this;
    }

    String getKernelId() {
        return this.getFirstFormOrNull("KernelId");
    }

    public RunInstancesOptions withRamdisk(String ramDiskId) {
        this.formParameters.put((Object)"RamdiskId", Preconditions.checkNotNull((Object)ramDiskId, (Object)"ramDiskId"));
        return this;
    }

    String getRamdiskId() {
        return this.getFirstFormOrNull("RamdiskId");
    }

    public RunInstancesOptions withVirtualName(String virtualName) {
        this.formParameters.put((Object)"BlockDeviceMapping.VirtualName", Preconditions.checkNotNull((Object)virtualName, (Object)"virtualName"));
        return this;
    }

    String getVirtualName() {
        return this.getFirstFormOrNull("BlockDeviceMapping.VirtualName");
    }

    public RunInstancesOptions withDeviceName(String deviceName) {
        this.formParameters.put((Object)"BlockDeviceMapping.DeviceName", Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName"));
        return this;
    }

    String getDeviceName() {
        return this.getFirstFormOrNull("BlockDeviceMapping.DeviceName");
    }

    public RunInstancesOptions enableMonitoring() {
        this.formParameters.put((Object)"Monitoring.Enabled", (Object)"true");
        return this;
    }

    String getMonitoringEnabled() {
        return this.getFirstFormOrNull("Monitoring.Enabled");
    }

    public RunInstancesOptions withSubnetId(String subnetId) {
        this.formParameters.put((Object)"SubnetId", Preconditions.checkNotNull((Object)subnetId, (Object)"subnetId"));
        return this;
    }

    String getSubnetId() {
        return this.getFirstFormOrNull("SubnetId");
    }

    public static class Builder {
        public static RunInstancesOptions withKeyName(String keyName) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKeyName(keyName);
        }

        public static RunInstancesOptions withSecurityGroup(String securityGroup) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withSecurityGroup(securityGroup);
        }

        public static RunInstancesOptions inPlacementGroup(String placementGroup) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.inPlacementGroup(placementGroup);
        }

        public static RunInstancesOptions withAdditionalInfo(String additionalInfo) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withAdditionalInfo(additionalInfo);
        }

        public static RunInstancesOptions withUserData(byte[] unencodedData) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withUserData(unencodedData);
        }

        public static RunInstancesOptions asType(String instanceType) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.asType(instanceType);
        }

        public static RunInstancesOptions withKernelId(String kernelId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKernelId(kernelId);
        }

        public static RunInstancesOptions withDeviceName(String deviceName) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withDeviceName(deviceName);
        }

        public static RunInstancesOptions enableMonitoring() {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.enableMonitoring();
        }

        public static RunInstancesOptions withSubnetId(String subnetId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withSubnetId(subnetId);
        }

        public static RunInstancesOptions withRamdisk(String ramdiskId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static RunInstancesOptions withVirtualName(String virtualName) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withVirtualName(virtualName);
        }
    }
}

