/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.aws.ec2.domain.IpPermission;

public class SecurityGroup
implements Comparable<SecurityGroup> {
    private final String region;
    private final String name;
    private final String ownerId;
    private final String description;
    private final Set<IpPermission> ipPermissions;

    public SecurityGroup(String region, String name, String ownerId, String description, Set<IpPermission> ipPermissions) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.name = name;
        this.ownerId = ownerId;
        this.description = description;
        this.ipPermissions = ipPermissions;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(SecurityGroup o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<IpPermission> getIpPermissions() {
        return this.ipPermissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.ipPermissions == null ? 0 : ((Object)this.ipPermissions).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.ipPermissions == null ? other.ipPermissions != null : !((Object)this.ipPermissions).equals(other.ipPermissions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    public String toString() {
        return "SecurityGroup [description=" + this.description + ", ipPermissions=" + this.ipPermissions + ", name=" + this.name + ", ownerId=" + this.ownerId + ", region=" + this.region + "]";
    }
}

