/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.internal.Nullable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.Attachment;
import org.jclouds.aws.ec2.domain.InstanceState;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.domain.RootDeviceType;

public class RunningInstance
implements Comparable<RunningInstance> {
    private final String region;
    private final Set<String> groupIds = Sets.newLinkedHashSet();
    private final String amiLaunchIndex;
    @Nullable
    private final String dnsName;
    private final String imageId;
    private final String instanceId;
    private final InstanceState instanceState;
    private final String instanceType;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final String kernelId;
    @Nullable
    private final String keyName;
    private final Date launchTime;
    private final MonitoringState monitoringState;
    private final String availabilityZone;
    @Nullable
    private final String placementGroup;
    private final String virtualizationType;
    @Nullable
    private final String platform;
    @Nullable
    private final String privateDnsName;
    @Nullable
    private final String privateIpAddress;
    private final Set<String> productCodes = Sets.newLinkedHashSet();
    @Nullable
    private final String ramdiskId;
    @Nullable
    private final String reason;
    @Nullable
    private final String subnetId;
    @Nullable
    private final String spotInstanceRequestId;
    @Nullable
    private final String vpcId;
    private final RootDeviceType rootDeviceType;
    @Nullable
    private final String rootDeviceName;
    private final Map<String, EbsBlockDevice> ebsBlockDevices = Maps.newHashMap();

    @Override
    public int compareTo(RunningInstance o) {
        return this == o ? 0 : this.getId().compareTo(o.getId());
    }

    public RunningInstance(String region, Iterable<String> groupIds, @Nullable String amiLaunchIndex, @Nullable String dnsName, String imageId, String instanceId, InstanceState instanceState, String instanceType, @Nullable String ipAddress, @Nullable String kernelId, @Nullable String keyName, Date launchTime, MonitoringState monitoringState, String availabilityZone, @Nullable String placementGroup, String virtualizationType, @Nullable String platform, @Nullable String privateDnsName, @Nullable String privateIpAddress, Set<String> productCodes, @Nullable String ramdiskId, @Nullable String reason, @Nullable String subnetId, @Nullable String spotInstanceRequestId, @Nullable String vpcId, RootDeviceType rootDeviceType, @Nullable String rootDeviceName, Map<String, EbsBlockDevice> ebsBlockDevices) {
        Iterables.addAll(this.groupIds, (Iterable)((Iterable)Preconditions.checkNotNull(groupIds, (Object)"groupIds")));
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.amiLaunchIndex = amiLaunchIndex;
        this.dnsName = dnsName;
        this.imageId = imageId;
        this.instanceId = (String)Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId");
        this.instanceState = (InstanceState)((Object)Preconditions.checkNotNull((Object)((Object)instanceState), (Object)"instanceState"));
        this.instanceType = (String)Preconditions.checkNotNull((Object)instanceType, (Object)"instanceType");
        this.ipAddress = ipAddress;
        this.kernelId = kernelId;
        this.keyName = keyName;
        this.launchTime = (Date)Preconditions.checkNotNull((Object)launchTime, (Object)"launchTime");
        this.monitoringState = monitoringState;
        this.availabilityZone = availabilityZone;
        this.placementGroup = placementGroup;
        this.virtualizationType = virtualizationType;
        this.platform = platform;
        this.privateDnsName = privateDnsName;
        this.privateIpAddress = privateIpAddress;
        Iterables.addAll(this.productCodes, (Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
        this.ramdiskId = ramdiskId;
        this.reason = reason;
        this.subnetId = subnetId;
        this.spotInstanceRequestId = spotInstanceRequestId;
        this.vpcId = vpcId;
        this.rootDeviceType = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)rootDeviceType), (Object)"rootDeviceType"));
        this.rootDeviceName = rootDeviceName;
        this.getEbsBlockDevices().putAll((Map)Preconditions.checkNotNull(ebsBlockDevices, (Object)"ebsBlockDevices"));
    }

    public String getRegion() {
        return this.region;
    }

    public String getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getId() {
        return this.instanceId;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public MonitoringState getMonitoringState() {
        return this.monitoringState;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Map<String, EbsBlockDevice> getEbsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amiLaunchIndex == null ? 0 : this.amiLaunchIndex.hashCode());
        result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
        result = 31 * result + (this.dnsName == null ? 0 : this.dnsName.hashCode());
        result = 31 * result + (this.ebsBlockDevices == null ? 0 : ((Object)this.ebsBlockDevices).hashCode());
        result = 31 * result + (this.groupIds == null ? 0 : ((Object)this.groupIds).hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.kernelId == null ? 0 : this.kernelId.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.launchTime == null ? 0 : this.launchTime.hashCode());
        result = 31 * result + (this.monitoringState == null ? 0 : this.monitoringState.hashCode());
        result = 31 * result + (this.placementGroup == null ? 0 : this.placementGroup.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (this.privateDnsName == null ? 0 : this.privateDnsName.hashCode());
        result = 31 * result + (this.privateIpAddress == null ? 0 : this.privateIpAddress.hashCode());
        result = 31 * result + (this.productCodes == null ? 0 : ((Object)this.productCodes).hashCode());
        result = 31 * result + (this.ramdiskId == null ? 0 : this.ramdiskId.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.rootDeviceName == null ? 0 : this.rootDeviceName.hashCode());
        result = 31 * result + (this.rootDeviceType == null ? 0 : this.rootDeviceType.hashCode());
        result = 31 * result + (this.spotInstanceRequestId == null ? 0 : this.spotInstanceRequestId.hashCode());
        result = 31 * result + (this.subnetId == null ? 0 : this.subnetId.hashCode());
        result = 31 * result + (this.virtualizationType == null ? 0 : this.virtualizationType.hashCode());
        result = 31 * result + (this.vpcId == null ? 0 : this.vpcId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunningInstance other = (RunningInstance)obj;
        if (this.amiLaunchIndex == null ? other.amiLaunchIndex != null : !this.amiLaunchIndex.equals(other.amiLaunchIndex)) {
            return false;
        }
        if (this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone)) {
            return false;
        }
        if (this.dnsName == null ? other.dnsName != null : !this.dnsName.equals(other.dnsName)) {
            return false;
        }
        if (this.ebsBlockDevices == null ? other.ebsBlockDevices != null : !((Object)this.ebsBlockDevices).equals(other.ebsBlockDevices)) {
            return false;
        }
        if (this.groupIds == null ? other.groupIds != null : !((Object)this.groupIds).equals(other.groupIds)) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.kernelId == null ? other.kernelId != null : !this.kernelId.equals(other.kernelId)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.launchTime == null ? other.launchTime != null : !this.launchTime.equals(other.launchTime)) {
            return false;
        }
        if (this.monitoringState == null ? other.monitoringState != null : !this.monitoringState.equals((Object)other.monitoringState)) {
            return false;
        }
        if (this.placementGroup == null ? other.placementGroup != null : !this.placementGroup.equals(other.placementGroup)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        if (this.privateDnsName == null ? other.privateDnsName != null : !this.privateDnsName.equals(other.privateDnsName)) {
            return false;
        }
        if (this.privateIpAddress == null ? other.privateIpAddress != null : !this.privateIpAddress.equals(other.privateIpAddress)) {
            return false;
        }
        if (this.productCodes == null ? other.productCodes != null : !((Object)this.productCodes).equals(other.productCodes)) {
            return false;
        }
        if (this.ramdiskId == null ? other.ramdiskId != null : !this.ramdiskId.equals(other.ramdiskId)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.rootDeviceName == null ? other.rootDeviceName != null : !this.rootDeviceName.equals(other.rootDeviceName)) {
            return false;
        }
        if (this.rootDeviceType == null ? other.rootDeviceType != null : !this.rootDeviceType.equals((Object)other.rootDeviceType)) {
            return false;
        }
        if (this.spotInstanceRequestId == null ? other.spotInstanceRequestId != null : !this.spotInstanceRequestId.equals(other.spotInstanceRequestId)) {
            return false;
        }
        if (this.subnetId == null ? other.subnetId != null : !this.subnetId.equals(other.subnetId)) {
            return false;
        }
        if (this.virtualizationType == null ? other.virtualizationType != null : !this.virtualizationType.equals(other.virtualizationType)) {
            return false;
        }
        return !(this.vpcId == null ? other.vpcId != null : !this.vpcId.equals(other.vpcId));
    }

    public String toString() {
        return "RunningInstance [amiLaunchIndex=" + this.amiLaunchIndex + ", availabilityZone=" + this.availabilityZone + ", placementGroup=" + this.placementGroup + ", virtualizationType=" + this.virtualizationType + ", dnsName=" + this.dnsName + ", ebsBlockDevices=" + this.ebsBlockDevices + ", groupIds=" + this.groupIds + ", imageId=" + this.imageId + ", instanceId=" + this.instanceId + ", instanceState=" + (Object)((Object)this.instanceState) + ", instanceType=" + this.instanceType + ", ipAddress=" + this.ipAddress + ", kernelId=" + this.kernelId + ", keyName=" + this.keyName + ", launchTime=" + this.launchTime + ", monitoringState=" + (Object)((Object)this.monitoringState) + ", platform=" + this.platform + ", privateDnsName=" + this.privateDnsName + ", privateIpAddress=" + this.privateIpAddress + ", productCodes=" + this.productCodes + ", ramdiskId=" + this.ramdiskId + ", reason=" + this.reason + ", region=" + this.region + ", rootDeviceName=" + this.rootDeviceName + ", rootDeviceType=" + (Object)((Object)this.rootDeviceType) + ", spotInstanceRequestId=" + this.spotInstanceRequestId + ", subnetId=" + this.subnetId + ", vpcId=" + this.vpcId + "]";
    }

    public static class EbsBlockDevice {
        private final String volumeId;
        private final Attachment.Status attachmentStatus;
        private final Date attachTime;
        private final boolean deleteOnTermination;

        public EbsBlockDevice(String volumeId, Attachment.Status attachmentStatus, Date attachTime, boolean deleteOnTermination) {
            this.volumeId = volumeId;
            this.attachmentStatus = attachmentStatus;
            this.attachTime = attachTime;
            this.deleteOnTermination = deleteOnTermination;
        }

        public EbsBlockDevice(String volumeId, boolean deleteOnTermination) {
            this(volumeId, null, null, deleteOnTermination);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attachTime == null ? 0 : this.attachTime.hashCode());
            result = 31 * result + (this.attachmentStatus == null ? 0 : this.attachmentStatus.hashCode());
            result = 31 * result + (this.deleteOnTermination ? 1231 : 1237);
            result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EbsBlockDevice other = (EbsBlockDevice)obj;
            if (this.attachTime == null ? other.attachTime != null : !this.attachTime.equals(other.attachTime)) {
                return false;
            }
            if (this.attachmentStatus == null ? other.attachmentStatus != null : !this.attachmentStatus.equals((Object)other.attachmentStatus)) {
                return false;
            }
            if (this.deleteOnTermination != other.deleteOnTermination) {
                return false;
            }
            return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
        }

        public String getVolumeId() {
            return this.volumeId;
        }

        public Attachment.Status getAttachmentStatus() {
            return this.attachmentStatus;
        }

        public Date getAttachTime() {
            return this.attachTime;
        }

        public boolean isDeleteOnTermination() {
            return this.deleteOnTermination;
        }
    }
}

