/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

public class ReservedInstancesOffering
implements Comparable<ReservedInstancesOffering> {
    private final String region;
    private final String availabilityZone;
    private final long duration;
    private final float fixedPrice;
    private final String instanceType;
    private final String productDescription;
    private final String id;
    private final float usagePrice;

    public ReservedInstancesOffering(String region, String availabilityZone, long duration, float fixedPrice, String instanceType, String productDescription, String reservedInstancesOfferingId, float usagePrice) {
        this.region = region;
        this.availabilityZone = availabilityZone;
        this.duration = duration;
        this.fixedPrice = fixedPrice;
        this.instanceType = instanceType;
        this.productDescription = productDescription;
        this.id = reservedInstancesOfferingId;
        this.usagePrice = usagePrice;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public long getDuration() {
        return this.duration;
    }

    public float getFixedPrice() {
        return this.fixedPrice;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String getId() {
        return this.id;
    }

    public float getUsagePrice() {
        return this.usagePrice;
    }

    @Override
    public int compareTo(ReservedInstancesOffering o) {
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return "[availabilityZone=" + this.availabilityZone + ", duration=" + this.duration + ", fixedPrice=" + this.fixedPrice + ", id=" + this.id + ", instanceType=" + this.instanceType + ", productDescription=" + this.productDescription + ", region=" + this.region + ", usagePrice=" + this.usagePrice + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + Float.floatToIntBits(this.fixedPrice);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.productDescription == null ? 0 : this.productDescription.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + Float.floatToIntBits(this.usagePrice);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering)obj;
        if (this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (Float.floatToIntBits(this.fixedPrice) != Float.floatToIntBits(other.fixedPrice)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.productDescription == null ? other.productDescription != null : !this.productDescription.equals(other.productDescription)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return Float.floatToIntBits(this.usagePrice) == Float.floatToIntBits(other.usagePrice);
    }
}

