/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.inject.internal.Nullable;

public class KeyPair
implements Comparable<KeyPair> {
    private final String region;
    private final String keyName;
    private final String keyFingerprint;
    @Nullable
    private final String keyMaterial;

    public KeyPair(String region, String keyName, String keyFingerprint, @Nullable String keyMaterial) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.keyName = (String)Preconditions.checkNotNull((Object)keyName, (Object)"keyName");
        this.keyFingerprint = (String)Preconditions.checkNotNull((Object)keyFingerprint, (Object)"keyFingerprint");
        this.keyMaterial = keyMaterial;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(KeyPair o) {
        return this == o ? 0 : this.getKeyName().compareTo(o.getKeyName());
    }

    public String getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyFingerprint == null ? 0 : this.keyFingerprint.hashCode());
        result = 31 * result + (this.keyMaterial == null ? 0 : this.keyMaterial.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (this.keyFingerprint == null ? other.keyFingerprint != null : !this.keyFingerprint.equals(other.keyFingerprint)) {
            return false;
        }
        if (this.keyMaterial == null ? other.keyMaterial != null : !this.keyMaterial.equals(other.keyMaterial)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }
}

