/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import java.util.Set;
import org.jclouds.aws.ec2.domain.IpProtocol;
import org.jclouds.aws.ec2.domain.UserIdGroupPair;

public class IpPermission
implements Comparable<IpPermission> {
    private final int fromPort;
    private final int toPort;
    private final Set<UserIdGroupPair> groups;
    private final IpProtocol ipProtocol;
    private final Set<String> ipRanges;

    public IpPermission(int fromPort, int toPort, Set<UserIdGroupPair> groups, IpProtocol ipProtocol, Set<String> ipRanges) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.groups = groups;
        this.ipProtocol = ipProtocol;
        this.ipRanges = ipRanges;
    }

    @Override
    public int compareTo(IpPermission o) {
        return this == o ? 0 : this.getIpProtocol().compareTo(o.getIpProtocol());
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public Set<UserIdGroupPair> getGroups() {
        return this.groups;
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromPort;
        result = 31 * result + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        result = 31 * result + (this.ipProtocol == null ? 0 : this.ipProtocol.hashCode());
        result = 31 * result + (this.ipRanges == null ? 0 : ((Object)this.ipRanges).hashCode());
        result = 31 * result + this.toPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (this.fromPort != other.fromPort) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups)) {
            return false;
        }
        if (this.ipProtocol == null ? other.ipProtocol != null : !this.ipProtocol.equals((Object)other.ipProtocol)) {
            return false;
        }
        if (this.ipRanges == null ? other.ipRanges != null : !((Object)this.ipRanges).equals(other.ipRanges)) {
            return false;
        }
        return this.toPort == other.toPort;
    }

    public String toString() {
        return "IpPermission [fromPort=" + this.fromPort + ", groups=" + this.groups + ", ipProtocol=" + (Object)((Object)this.ipProtocol) + ", ipRanges=" + this.ipRanges + ", toPort=" + this.toPort + "]";
    }
}

