/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum InstanceState {
    PENDING,
    RUNNING,
    SHUTTING_DOWN,
    TERMINATED,
    STOPPING,
    STOPPED,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static InstanceState fromValue(String state) {
        try {
            return InstanceState.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    public static InstanceState fromValue(int v) {
        switch (v) {
            case 0: {
                return PENDING;
            }
            case 16: {
                return RUNNING;
            }
            case 32: {
                return SHUTTING_DOWN;
            }
            case 48: {
                return TERMINATED;
            }
            case 64: {
                return STOPPING;
            }
            case 80: {
                return STOPPED;
            }
        }
        return UNRECOGNIZED;
    }
}

