/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.internal.Nullable;
import org.jclouds.aws.ec2.domain.RunningInstance;

public class BlockDeviceMapping {
    private final Multimap<String, RunningInstance.EbsBlockDevice> ebsBlockDevices = LinkedHashMultimap.create();

    public BlockDeviceMapping() {
    }

    public BlockDeviceMapping(Multimap<String, RunningInstance.EbsBlockDevice> ebsBlockDevices) {
        this.ebsBlockDevices.putAll((Multimap)Preconditions.checkNotNull(ebsBlockDevices, (Object)"EbsBlockDevices can't be null"));
    }

    public BlockDeviceMapping addEbsBlockDevice(@Nullable String deviceName, RunningInstance.EbsBlockDevice ebsBlockDevice) {
        this.ebsBlockDevices.put((Object)deviceName, Preconditions.checkNotNull((Object)ebsBlockDevice, (Object)"EbsBlockDevice can't be null"));
        return this;
    }

    public Multimap<String, RunningInstance.EbsBlockDevice> getEbsBlockDevices() {
        return ImmutableMultimap.builder().putAll(this.ebsBlockDevices).build();
    }
}

