/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Date;

public class Attachment
implements Comparable<Attachment> {
    private final String region;
    private final String volumeId;
    private final String instanceId;
    private final String device;
    private final Status status;
    private final Date attachTime;

    public Attachment(String region, String volumeId, String instanceId, String device, Status status, Date attachTime) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.volumeId = volumeId;
        this.instanceId = instanceId;
        this.device = device;
        this.status = status;
        this.attachTime = attachTime;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public String getId() {
        return this.instanceId;
    }

    public String getDevice() {
        return this.device;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getAttachTime() {
        return this.attachTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachTime == null ? 0 : this.attachTime.hashCode());
        result = 31 * result + (this.device == null ? 0 : this.device.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (this.attachTime == null ? other.attachTime != null : !this.attachTime.equals(other.attachTime)) {
            return false;
        }
        if (this.device == null ? other.device != null : !this.device.equals(other.device)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    public String toString() {
        return "Attachment [region=" + this.region + ", volumeId=" + this.volumeId + ", instanceId=" + this.instanceId + ", device=" + this.device + ", attachTime=" + this.attachTime + ", status=" + (Object)((Object)this.status) + "]";
    }

    @Override
    public int compareTo(Attachment o) {
        return this.attachTime.compareTo(o.attachTime);
    }

    public static enum Status {
        ATTACHING,
        ATTACHED,
        DETACHING,
        DETACHED,
        BUSY,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(((String)Preconditions.checkNotNull((Object)status, (Object)"status")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

