/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.aws.config.AWSFormSigningRestClientModule;
import org.jclouds.aws.ec2.EC2AsyncClient;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.aws.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.aws.ec2.options.DescribeRegionsOptions;
import org.jclouds.aws.ec2.services.AMIAsyncClient;
import org.jclouds.aws.ec2.services.AMIClient;
import org.jclouds.aws.ec2.services.AvailabilityZoneAndRegionAsyncClient;
import org.jclouds.aws.ec2.services.AvailabilityZoneAndRegionClient;
import org.jclouds.aws.ec2.services.ElasticBlockStoreAsyncClient;
import org.jclouds.aws.ec2.services.ElasticBlockStoreClient;
import org.jclouds.aws.ec2.services.ElasticIPAddressAsyncClient;
import org.jclouds.aws.ec2.services.ElasticIPAddressClient;
import org.jclouds.aws.ec2.services.InstanceAsyncClient;
import org.jclouds.aws.ec2.services.InstanceClient;
import org.jclouds.aws.ec2.services.KeyPairAsyncClient;
import org.jclouds.aws.ec2.services.KeyPairClient;
import org.jclouds.aws.ec2.services.MonitoringAsyncClient;
import org.jclouds.aws.ec2.services.MonitoringClient;
import org.jclouds.aws.ec2.services.PlacementGroupAsyncClient;
import org.jclouds.aws.ec2.services.PlacementGroupClient;
import org.jclouds.aws.ec2.services.SecurityGroupAsyncClient;
import org.jclouds.aws.ec2.services.SecurityGroupClient;
import org.jclouds.aws.ec2.services.WindowsAsyncClient;
import org.jclouds.aws.ec2.services.WindowsClient;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;

@RequiresHttp
@ConfiguresRestClient
public class EC2RestClientModule
extends AWSFormSigningRestClientModule<EC2Client, EC2AsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(AMIClient.class, AMIAsyncClient.class).put(ElasticIPAddressClient.class, ElasticIPAddressAsyncClient.class).put(InstanceClient.class, InstanceAsyncClient.class).put(KeyPairClient.class, KeyPairAsyncClient.class).put(SecurityGroupClient.class, SecurityGroupAsyncClient.class).put(PlacementGroupClient.class, PlacementGroupAsyncClient.class).put(MonitoringClient.class, MonitoringAsyncClient.class).put(WindowsClient.class, WindowsAsyncClient.class).put(AvailabilityZoneAndRegionClient.class, AvailabilityZoneAndRegionAsyncClient.class).put(ElasticBlockStoreClient.class, ElasticBlockStoreAsyncClient.class).build();
    private RuntimeException regionException = null;

    public EC2RestClientModule() {
        super(EC2Client.class, EC2AsyncClient.class, DELEGATE_MAP);
    }

    @Override
    protected Map<String, URI> provideRegions(Injector injector) {
        if (this.regionException != null) {
            throw this.regionException;
        }
        EC2Client client = (EC2Client)injector.getInstance(EC2Client.class);
        try {
            return client.getAvailabilityZoneAndRegionServices().describeRegions(new DescribeRegionsOptions[0]);
        }
        catch (RuntimeException e) {
            this.regionException = e;
            throw e;
        }
    }

    @Provides
    @Singleton
    protected Map<String, String> provideAvailabilityZoneToRegions(EC2Client client, @Region Map<String, URI> regions) {
        HashMap map = Maps.newHashMap();
        for (String region : regions.keySet()) {
            for (AvailabilityZoneInfo zoneInfo : client.getAvailabilityZoneAndRegionServices().describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[0])) {
                map.put(zoneInfo.getZone(), region);
            }
        }
        return map;
    }
}

