/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.util;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

@Singleton
public class EC2ComputeUtils {
    public static Function<RunningInstance, String> instanceToId = new Function<RunningInstance, String>(){

        public String apply(RunningInstance from) {
            return from.getId();
        }
    };

    public static String getRegionFromLocationOrNull(Location location) {
        return location.getScope() == LocationScope.ZONE ? location.getParent().getId() : location.getId();
    }

    public static String getZoneFromLocationOrNull(Location location) {
        return location.getScope() == LocationScope.ZONE ? location.getId() : null;
    }
}

