/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.functions.ImageParser;
import org.jclouds.aws.ec2.compute.strategy.DescribeImagesParallel;
import org.jclouds.aws.ec2.options.DescribeImagesOptions;
import org.jclouds.compute.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class RegionAndNameToImageSupplier
implements Supplier<Map<RegionAndName, ? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<String, URI> regionMap;
    private final DescribeImagesParallel describer;
    private final String[] ccAmis;
    private final String[] amiOwners;
    private final ImageParser parser;
    private final Map<RegionAndName, Image> images;

    @Inject
    RegionAndNameToImageSupplier(@Region Map<String, URI> regionMap, DescribeImagesParallel describer, @Named(value="jclouds.ec2.cc-amis") String[] ccAmis, @Named(value="jclouds.ec2.ami-owners") String[] amiOwners, ImageParser parser, Map<RegionAndName, Image> images) {
        this.regionMap = regionMap;
        this.describer = describer;
        this.ccAmis = ccAmis;
        this.amiOwners = amiOwners;
        this.parser = parser;
        this.images = images;
    }

    public Map<RegionAndName, ? extends Image> get() {
        if (this.amiOwners.length == 0) {
            this.logger.debug(">> no owners specified, skipping image parsing", new Object[0]);
        } else {
            this.logger.debug(">> providing images", new Object[0]);
            Iterable queries = Iterables.concat(RegionAndNameToImageSupplier.getDescribeQueriesForOwnersInRegions(this.regionMap, this.amiOwners).entrySet(), RegionAndNameToImageSupplier.ccAmisToDescribeQueries(this.ccAmis).entrySet());
            Iterable parsedImages = Iterables.filter((Iterable)Iterables.transform(this.describer.apply(queries), (Function)this.parser), (Predicate)Predicates.notNull());
            this.images.putAll((Map<RegionAndName, Image>)Maps.uniqueIndex((Iterable)parsedImages, (Function)new Function<Image, RegionAndName>(){

                public RegionAndName apply(Image from) {
                    return new RegionAndName(from.getLocation().getId(), from.getProviderId());
                }
            }));
            this.logger.debug("<< images(%d)", new Object[]{this.images.size()});
        }
        return this.images;
    }

    private static Map<String, DescribeImagesOptions> ccAmisToDescribeQueries(String[] ccAmis) {
        LinkedHashMap queries = Maps.newLinkedHashMap();
        for (String from : ccAmis) {
            queries.put(from.split("/")[0], DescribeImagesOptions.Builder.imageIds(from.split("/")[1]));
        }
        return queries;
    }

    private static Map<String, DescribeImagesOptions> getDescribeQueriesForOwnersInRegions(Map<String, URI> regionMap, String[] amiOwners) {
        final DescribeImagesOptions options = RegionAndNameToImageSupplier.getOptionsForOwners(amiOwners);
        return Maps.transformValues(regionMap, (Function)new Function<URI, DescribeImagesOptions>(){

            public DescribeImagesOptions apply(URI from) {
                return options;
            }
        });
    }

    private static DescribeImagesOptions getOptionsForOwners(String[] amiOwners) {
        DescribeImagesOptions options = amiOwners.length == 1 && amiOwners[0].equals("*") ? new DescribeImagesOptions() : DescribeImagesOptions.Builder.ownedBy(amiOwners);
        return options;
    }
}

