/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;
import org.jclouds.rest.annotations.Provider;

@Singleton
public class EC2LocationSupplier
implements Supplier<Set<? extends Location>> {
    private final Map<String, String> availabilityZoneToRegionMap;
    private final String providerName;

    @Inject
    EC2LocationSupplier(Map<String, String> availabilityZoneToRegionMap, @Provider String providerName) {
        this.availabilityZoneToRegionMap = availabilityZoneToRegionMap;
        this.providerName = providerName;
    }

    public Set<? extends Location> get() {
        LocationImpl ec2 = new LocationImpl(LocationScope.PROVIDER, this.providerName, this.providerName, null);
        LinkedHashSet locations = Sets.newLinkedHashSet();
        for (String region : Sets.newLinkedHashSet(this.availabilityZoneToRegionMap.values())) {
            locations.add(new LocationImpl(LocationScope.REGION, region, region, (Location)ec2));
        }
        ImmutableMap idToLocation = Maps.uniqueIndex((Iterable)locations, (Function)new Function<Location, String>(){

            public String apply(Location from) {
                return from.getId();
            }
        });
        for (String zone : this.availabilityZoneToRegionMap.keySet()) {
            locations.add(new LocationImpl(LocationScope.ZONE, zone, zone, (Location)idToLocation.get((Object)this.availabilityZoneToRegionMap.get(zone))));
        }
        return locations;
    }
}

