/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Provider;

@Singleton
public class EC2HardwareSupplier
implements Supplier<Set<? extends Hardware>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<Set<? extends Location>> locations;
    private final String[] ccAmis;
    private final String providerName;

    @Inject
    EC2HardwareSupplier(@Memoized Supplier<Set<? extends Location>> locations, @Provider String providerName, @Named(value="jclouds.ec2.cc-amis") String[] ccAmis) {
        this.locations = locations;
        this.ccAmis = ccAmis;
        this.providerName = providerName;
    }

    public Set<? extends Hardware> get() {
        LinkedHashSet sizes = Sets.newLinkedHashSet();
        for (String ccAmi : this.ccAmis) {
            final String region = ccAmi.split("/")[0];
            Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getScope() == LocationScope.REGION && input.getId().equals(region);
                }
            });
            sizes.add(EC2HardwareBuilder.cc1_4xlarge().location(location).supportsImageIds(ccAmi).build());
        }
        sizes.addAll(ImmutableSet.of((Object)EC2HardwareBuilder.t1_micro().build(), (Object)EC2HardwareBuilder.c1_medium().build(), (Object)EC2HardwareBuilder.c1_xlarge().build(), (Object)EC2HardwareBuilder.m1_large().build(), (Object)(!"ec2".equals(this.providerName) ? EC2HardwareBuilder.m1_small().supportsImage(ImagePredicates.any()).build() : EC2HardwareBuilder.m1_small().build()), (Object)EC2HardwareBuilder.m1_xlarge().build(), (Object[])new Hardware[]{EC2HardwareBuilder.m2_xlarge().build(), EC2HardwareBuilder.m2_2xlarge().build(), EC2HardwareBuilder.m2_4xlarge().build()}));
        return sizes;
    }
}

