/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.compute.util.EC2ComputeUtils;
import org.jclouds.aws.ec2.domain.Reservation;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.options.RunInstancesOptions;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.RunNodesAndAddToSetStrategy;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;

@Singleton
public class EC2RunNodesAndAddToSetStrategy
implements RunNodesAndAddToSetStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    final EC2Client client;
    @VisibleForTesting
    final CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
    @VisibleForTesting
    final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    @VisibleForTesting
    final ComputeUtils utils;
    final Predicate<RunningInstance> instancePresent;
    final Function<RunningInstance, Credentials> instanceToCredentials;
    final Map<String, Credentials> credentialStore;

    @Inject
    EC2RunNodesAndAddToSetStrategy(EC2Client client, CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions, @Named(value="PRESENT") Predicate<RunningInstance> instancePresent, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, Function<RunningInstance, Credentials> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils) {
        this.client = client;
        this.instancePresent = instancePresent;
        this.createKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions = createKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
        this.runningInstanceToNodeMetadata = runningInstanceToNodeMetadata;
        this.instanceToCredentials = instanceToCredentials;
        this.credentialStore = credentialStore;
        this.utils = utils;
    }

    public Map<?, Future<Void>> execute(String tag, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes) {
        Reservation<? extends RunningInstance> reservation = this.createKeyPairAndSecurityGroupsAsNeededThenRunInstances(tag, count, template);
        Iterable ids = Iterables.transform(reservation, EC2ComputeUtils.instanceToId);
        String idsString = Joiner.on((char)',').join(ids);
        if (Iterables.size((Iterable)ids) > 0) {
            this.logger.debug("<< started instances(%s)", new Object[]{idsString});
            Iterables.all(reservation, this.instancePresent);
            this.logger.debug("<< present instances(%s)", new Object[]{idsString});
            this.populateCredentials(reservation);
        }
        return this.utils.runOptionsOnNodesAndAddToGoodSetOrPutExceptionIntoBadMap(template.getOptions(), Iterables.transform(reservation, this.runningInstanceToNodeMetadata), goodNodes, badNodes);
    }

    protected void populateCredentials(Reservation<? extends RunningInstance> reservation) {
        RunningInstance instance1 = (RunningInstance)Iterables.get(reservation, (int)0);
        Credentials credentials = (Credentials)this.instanceToCredentials.apply((Object)instance1);
        if (credentials != null) {
            for (RunningInstance runningInstance : reservation) {
                this.credentialStore.put("node#" + runningInstance.getRegion() + "/" + runningInstance.getId(), credentials);
            }
        }
    }

    @VisibleForTesting
    Reservation<? extends RunningInstance> createKeyPairAndSecurityGroupsAsNeededThenRunInstances(String tag, int count, Template template) {
        String region = EC2ComputeUtils.getRegionFromLocationOrNull(template.getLocation());
        String zone = EC2ComputeUtils.getZoneFromLocationOrNull(template.getLocation());
        RunInstancesOptions instanceOptions = this.createKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.execute(region, tag, template);
        if (((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(template.getOptions()))).isMonitoringEnabled()) {
            instanceOptions.enableMonitoring();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> running %d instance region(%s) zone(%s) ami(%s) params(%s)", new Object[]{count, region, zone, template.getImage().getProviderId(), instanceOptions.buildFormParameters()});
        }
        return this.client.getInstanceServices().runInstancesInRegion(region, zone, template.getImage().getProviderId(), 1, count, instanceOptions);
    }
}

