/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.services.InstanceClient;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;

@Singleton
public class EC2ResumeNodeStrategy
implements ResumeNodeStrategy {
    private final InstanceClient client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected EC2ResumeNodeStrategy(EC2Client client, GetNodeMetadataStrategy getNode) {
        this.client = client.getInstanceServices();
        this.getNode = getNode;
    }

    public NodeMetadata resumeNode(String id) {
        String[] parts = EC2Utils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        this.client.startInstancesInRegion(region, instanceId);
        return this.getNode.getNode(id);
    }
}

