/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.Image;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;

@Singleton
public class EC2PopulateDefaultLoginCredentialsForImageStrategy
implements PopulateDefaultLoginCredentialsForImageStrategy {
    public Credentials execute(Object resourceToAuthenticate) {
        Credentials credentials = new Credentials("root", null);
        if (resourceToAuthenticate != null) {
            String owner = null;
            if (resourceToAuthenticate instanceof Image) {
                owner = ((Image)Image.class.cast(resourceToAuthenticate)).getImageOwnerId();
            } else if (resourceToAuthenticate instanceof org.jclouds.compute.domain.Image) {
                owner = (String)((org.jclouds.compute.domain.Image)org.jclouds.compute.domain.Image.class.cast(resourceToAuthenticate)).getUserMetadata().get("owner");
            }
            Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"Resource must be an image (for EC2)");
            if (owner.matches("063491364108|099720109477")) {
                credentials = new Credentials("ubuntu", null);
            } else if (owner.equals("137112412989")) {
                credentials = new Credentials("ec2-user", null);
            }
        }
        return credentials;
    }
}

