/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.aws.elb.ELBClient;
import org.jclouds.compute.strategy.LoadBalanceNodesStrategy;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

@Singleton
public class EC2LoadBalanceNodesStrategy
implements LoadBalanceNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ELBClient elbClient;
    protected final EC2Utils.GetRegionFromLocation getRegionFromLocation;

    @Inject
    protected EC2LoadBalanceNodesStrategy(ELBClient elbClient, EC2Utils.GetRegionFromLocation getRegionFromLocation) {
        this.elbClient = elbClient;
        this.getRegionFromLocation = getRegionFromLocation;
    }

    public String execute(Location location, String name, String protocol, int loadBalancerPort, int instancePort, Set<String> instanceIds) {
        String region = this.getRegionFromLocation.apply(location);
        String dnsName = new String();
        dnsName = this.elbClient.createLoadBalancerInRegion(region, name, protocol, loadBalancerPort, instancePort, EC2Utils.getAvailabilityZonesForRegion(region));
        ArrayList<String> instanceIdlist = new ArrayList<String>(instanceIds);
        String[] instanceIdArray = new String[instanceIdlist.size()];
        for (int i = 0; i < instanceIdlist.size(); ++i) {
            instanceIdArray[i] = (String)instanceIdlist.get(i);
        }
        Set<String> registeredInstanceIds = this.elbClient.registerInstancesWithLoadBalancerInRegion(region, name, instanceIdArray);
        boolean changed = registeredInstanceIds.removeAll(instanceIds);
        if (changed) {
            ArrayList<String> list = new ArrayList<String>(registeredInstanceIds);
            instanceIdArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                instanceIdArray[i] = (String)list.get(i);
            }
            if (instanceIdArray.length > 0) {
                this.elbClient.deregisterInstancesWithLoadBalancerInRegion(region, name, instanceIdArray);
            }
        }
        return dnsName;
    }
}

