/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.EC2AsyncClient;
import org.jclouds.aws.ec2.domain.Reservation;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ListNodesStrategy
implements ListNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final EC2AsyncClient client;
    private final Map<String, URI> regionMap;
    private final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    private final ExecutorService executor;

    @Inject
    protected EC2ListNodesStrategy(EC2AsyncClient client, @Region Map<String, URI> regionMap, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.client = client;
        this.regionMap = regionMap;
        this.runningInstanceToNodeMetadata = runningInstanceToNodeMetadata;
        this.executor = executor;
    }

    public Set<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching(NodePredicates.all());
    }

    public Set<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        Iterable reservations = FutureIterables.transformParallel(this.regionMap.keySet(), (Function)new Function<String, Future<Set<? extends Reservation<? extends RunningInstance>>>>(){

            public Future<Set<? extends Reservation<? extends RunningInstance>>> apply(String from) {
                return EC2ListNodesStrategy.this.client.getInstanceServices().describeInstancesInRegion(from, new String[0]);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"reservations");
        Iterable instances = Iterables.concat((Iterable)Iterables.concat((Iterable)reservations));
        Iterable nodes = Iterables.filter((Iterable)Iterables.transform((Iterable)instances, this.runningInstanceToNodeMetadata), filter);
        return Sets.newLinkedHashSet((Iterable)nodes);
    }
}

