/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.elb.ELBClient;
import org.jclouds.aws.elb.domain.LoadBalancer;
import org.jclouds.compute.strategy.ListLoadBalancersStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ListLoadBalancersStrategy
implements ListLoadBalancersStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ELBClient elbClient;

    @Inject
    protected EC2ListLoadBalancersStrategy(ELBClient elbClient) {
        this.elbClient = (ELBClient)Preconditions.checkNotNull((Object)elbClient, (Object)"elbClient");
    }

    public Set<String> execute() {
        Set<LoadBalancer> loadBalancers = this.elbClient.describeLoadBalancersInRegion(null);
        HashSet<String> loadBalancerDnsNames = new HashSet<String>();
        for (LoadBalancer loadBalancer : loadBalancers) {
            loadBalancerDnsNames.add(loadBalancer.getDnsName());
        }
        return loadBalancerDnsNames;
    }
}

