/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;

@Singleton
public class EC2GetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    private final EC2Client client;
    private final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;

    @Inject
    protected EC2GetNodeMetadataStrategy(EC2Client client, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata) {
        this.client = client;
        this.runningInstanceToNodeMetadata = runningInstanceToNodeMetadata;
    }

    public NodeMetadata getNode(String id) {
        String[] parts = EC2Utils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        try {
            RunningInstance runningInstance = (RunningInstance)Iterables.getOnlyElement(EC2Utils.getAllRunningInstancesInRegion(this.client.getInstanceServices(), region, instanceId));
            return (NodeMetadata)this.runningInstanceToNodeMetadata.apply((Object)runningInstance);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

