/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class EC2DestroyNodeStrategy
implements DestroyNodeStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Client ec2Client;
    protected final GetNodeMetadataStrategy getNode;

    @Inject
    protected EC2DestroyNodeStrategy(EC2Client ec2Client, GetNodeMetadataStrategy getNodeMetadataStrategy) {
        this.ec2Client = ec2Client;
        this.getNode = getNodeMetadataStrategy;
    }

    public NodeMetadata destroyNode(String id) {
        String[] parts = EC2Utils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        this.ec2Client.getInstanceServices().terminateInstancesInRegion(region, instanceId);
        return this.getNode.getNode(id);
    }
}

