/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.aws.elb.ELBClient;
import org.jclouds.compute.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class EC2DestroyLoadBalancerStrategy
implements DestroyLoadBalancerStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ELBClient elbClient;

    @Inject
    protected EC2DestroyLoadBalancerStrategy(ELBClient elbClient) {
        this.elbClient = (ELBClient)Preconditions.checkNotNull((Object)elbClient, (Object)"elbClient");
    }

    public boolean execute(String loadBalancer) {
        Map<String, String> tuple = EC2Utils.getLoadBalancerNameAndRegionFromDnsName(loadBalancer);
        for (String key : tuple.keySet()) {
            this.elbClient.deleteLoadBalancerInRegion(key, tuple.get(key));
        }
        return true;
    }
}

