/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.aws.ec2.compute.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.aws.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.aws.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.options.RunInstancesOptions;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;

@Singleton
public class CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions {
    @VisibleForTesting
    final Map<RegionAndName, KeyPair> credentialsMap;
    @VisibleForTesting
    final Map<RegionAndName, String> securityGroupMap;
    @VisibleForTesting
    final Map<RegionAndName, String> placementGroupMap;
    @VisibleForTesting
    final CreateUniqueKeyPair createUniqueKeyPair;
    @VisibleForTesting
    final CreateSecurityGroupIfNeeded createSecurityGroupIfNeeded;
    @VisibleForTesting
    final CreatePlacementGroupIfNeeded createPlacementGroupIfNeeded;

    @Inject
    CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions(Map<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") Map<RegionAndName, String> securityGroupMap, @Named(value="PLACEMENT") Map<RegionAndName, String> placementGroupMap, CreateUniqueKeyPair createUniqueKeyPair, CreateSecurityGroupIfNeeded createSecurityGroupIfNeeded, CreatePlacementGroupIfNeeded createPlacementGroupIfNeeded) {
        this.credentialsMap = credentialsMap;
        this.securityGroupMap = securityGroupMap;
        this.placementGroupMap = placementGroupMap;
        this.createUniqueKeyPair = createUniqueKeyPair;
        this.createSecurityGroupIfNeeded = createSecurityGroupIfNeeded;
        this.createPlacementGroupIfNeeded = createPlacementGroupIfNeeded;
    }

    public RunInstancesOptions execute(String region, String tag, Template template) {
        byte[] userData;
        RunInstancesOptions instanceOptions = RunInstancesOptions.Builder.asType(template.getHardware().getId()).withAdditionalInfo(tag);
        String keyPairName = this.createNewKeyPairUnlessUserSpecifiedOtherwise(region, tag, template.getOptions());
        String placementGroupName = template.getHardware().getId().startsWith("cc") ? this.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, tag, template.getOptions()) : null;
        String subnetId = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(template.getOptions()))).getSubnetId();
        if (subnetId != null) {
            instanceOptions.withSubnetId(subnetId);
        } else {
            Set<String> groups = this.getSecurityGroupsForTagAndOptions(region, tag, template.getOptions());
            instanceOptions.withSecurityGroups(groups);
        }
        if (keyPairName != null) {
            instanceOptions.withKeyName(keyPairName);
        }
        if (placementGroupName != null) {
            instanceOptions.inPlacementGroup(placementGroupName);
        }
        if ((userData = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(template.getOptions()))).getUserData()) != null) {
            instanceOptions.withUserData(userData);
        }
        return instanceOptions;
    }

    @VisibleForTesting
    String createNewKeyPairUnlessUserSpecifiedOtherwise(String region, String tag, TemplateOptions options) {
        String keyPairName = null;
        boolean shouldAutomaticallyCreateKeyPair = true;
        if (options instanceof EC2TemplateOptions && (keyPairName = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).getKeyPair()) == null) {
            shouldAutomaticallyCreateKeyPair = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).shouldAutomaticallyCreateKeyPair();
        }
        if (keyPairName == null && shouldAutomaticallyCreateKeyPair) {
            RegionAndName regionAndName = new RegionAndName(region, tag);
            KeyPair keyPair = this.createUniqueKeyPair.apply(regionAndName);
            this.credentialsMap.put(new RegionAndName(region, keyPair.getKeyName()), keyPair);
            keyPairName = keyPair.getKeyName();
        }
        return keyPairName;
    }

    @VisibleForTesting
    String createNewPlacementGroupUnlessUserSpecifiedOtherwise(String region, String tag, TemplateOptions options) {
        RegionAndName regionAndName;
        String placementGroupName = null;
        boolean shouldAutomaticallyCreatePlacementGroup = true;
        if (options instanceof EC2TemplateOptions && (placementGroupName = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).getPlacementGroup()) == null) {
            shouldAutomaticallyCreatePlacementGroup = ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).shouldAutomaticallyCreatePlacementGroup();
        }
        if (placementGroupName == null && shouldAutomaticallyCreatePlacementGroup && !this.placementGroupMap.containsKey(regionAndName = new RegionAndName(region, placementGroupName = String.format("jclouds#%s#%s", tag, region)))) {
            this.placementGroupMap.put(regionAndName, this.createPlacementGroupIfNeeded.apply(regionAndName));
        }
        return placementGroupName;
    }

    @VisibleForTesting
    Set<String> getSecurityGroupsForTagAndOptions(String region, @Nullable String tag, TemplateOptions options) {
        LinkedHashSet groups = Sets.newLinkedHashSet();
        if (tag != null) {
            RegionNameAndIngressRules regionNameAndIngessRulesForMarkerGroup;
            String markerGroup = String.format("jclouds#%s#%s", tag, region);
            groups.add(markerGroup);
            if (options instanceof EC2TemplateOptions && ((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).getGroupIds().size() > 0) {
                regionNameAndIngessRulesForMarkerGroup = new RegionNameAndIngressRules(region, markerGroup, new int[0], false);
                groups.addAll(((EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(options))).getGroupIds());
            } else {
                regionNameAndIngessRulesForMarkerGroup = new RegionNameAndIngressRules(region, markerGroup, options.getInboundPorts(), true);
            }
            if (!this.securityGroupMap.containsKey(regionNameAndIngessRulesForMarkerGroup)) {
                this.securityGroupMap.put(regionNameAndIngessRulesForMarkerGroup, this.createSecurityGroupIfNeeded.apply(regionNameAndIngessRulesForMarkerGroup));
            }
        }
        return groups;
    }
}

