/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.io.Payload;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Utils;

public class EC2TemplateOptions
extends TemplateOptions {
    private Set<String> groupIds = ImmutableSet.of();
    private String keyPair = null;
    private boolean noKeyPair;
    private boolean monitoringEnabled;
    private String placementGroup = null;
    private boolean noPlacementGroup;
    private String subnetId;
    private byte[] userData;
    public static final EC2TemplateOptions NONE = new EC2TemplateOptions();

    public EC2TemplateOptions securityGroups(String ... groupIds) {
        return this.securityGroups((Iterable<String>)ImmutableSet.copyOf((Object[])groupIds));
    }

    public EC2TemplateOptions securityGroups(Iterable<String> groupIds) {
        Preconditions.checkArgument((Iterables.size(groupIds) > 0 ? 1 : 0) != 0, (Object)"you must specify at least one security group");
        for (String groupId : groupIds) {
            Utils.checkNotEmpty((String)groupId, (String)"all security groups must be non-empty");
        }
        this.groupIds = ImmutableSet.copyOf(groupIds);
        return this;
    }

    public EC2TemplateOptions enableMonitoring() {
        this.monitoringEnabled = true;
        return this;
    }

    public EC2TemplateOptions userData(byte[] unencodedData) {
        Preconditions.checkArgument((((byte[])Preconditions.checkNotNull((Object)unencodedData, (Object)"unencodedData")).length <= 16384 ? 1 : 0) != 0, (Object)"userData cannot be larger than 16kb");
        this.userData = unencodedData;
        return this;
    }

    public EC2TemplateOptions keyPair(String keyPair) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"use noKeyPair option to request boot without a keypair");
        Preconditions.checkState((!this.noKeyPair ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        Utils.checkNotEmpty((String)keyPair, (String)"keypair must be non-empty");
        this.keyPair = keyPair;
        return this;
    }

    public EC2TemplateOptions noKeyPair() {
        Preconditions.checkState((this.keyPair == null ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        this.noKeyPair = true;
        return this;
    }

    public EC2TemplateOptions placementGroup(String placementGroup) {
        Preconditions.checkNotNull((Object)placementGroup, (Object)"use noPlacementGroup option to request boot without a keypair");
        Preconditions.checkState((!this.noPlacementGroup ? 1 : 0) != 0, (Object)"you cannot specify both options placementGroup and noPlacementGroup");
        Utils.checkNotEmpty((String)placementGroup, (String)"placementGroup must be non-empty");
        this.placementGroup = placementGroup;
        return this;
    }

    public EC2TemplateOptions noPlacementGroup() {
        Preconditions.checkState((this.placementGroup == null ? 1 : 0) != 0, (Object)"you cannot specify both options placementGroup and noPlacementGroup");
        this.noPlacementGroup = true;
        return this;
    }

    public EC2TemplateOptions subnetId(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)"subnetId cannot be null");
        Utils.checkNotEmpty((String)subnetId, (String)"subnetId must be non-empty");
        this.subnetId = subnetId;
        return this;
    }

    public EC2TemplateOptions blockOnPort(int port, int seconds) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.blockOnPort(port, seconds)));
    }

    public EC2TemplateOptions inboundPorts(int ... ports) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.inboundPorts(ports)));
    }

    public EC2TemplateOptions authorizePublicKey(String publicKey) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    @Deprecated
    public EC2TemplateOptions authorizePublicKey(Payload publicKey) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    public EC2TemplateOptions installPrivateKey(String privateKey) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    @Deprecated
    public EC2TemplateOptions installPrivateKey(Payload privateKey) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    public EC2TemplateOptions runScript(Payload script) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.runScript(script)));
    }

    @Deprecated
    public EC2TemplateOptions runScript(byte[] script) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.runScript(script)));
    }

    public EC2TemplateOptions withMetadata() {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.withMetadata()));
    }

    public EC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning)));
    }

    public EC2TemplateOptions dontAuthorizePublicKey() {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.dontAuthorizePublicKey()));
    }

    public EC2TemplateOptions nameTask(String name) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.nameTask(name)));
    }

    public EC2TemplateOptions runAsRoot(boolean runAsRoot) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.runAsRoot(runAsRoot)));
    }

    public EC2TemplateOptions runScript(Statement script) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.runScript(script)));
    }

    public EC2TemplateOptions withOverridingCredentials(Credentials overridingCredentials) {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.withOverridingCredentials(overridingCredentials)));
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public boolean shouldAutomaticallyCreateKeyPair() {
        return !this.noKeyPair;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public boolean shouldAutomaticallyCreatePlacementGroup() {
        return !this.noPlacementGroup;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groupIds == null ? 0 : ((Object)this.groupIds).hashCode());
        result = 31 * result + (this.keyPair == null ? 0 : this.keyPair.hashCode());
        result = 31 * result + (this.noKeyPair ? 1231 : 1237);
        result = 31 * result + (this.noPlacementGroup ? 1231 : 1237);
        result = 31 * result + (this.monitoringEnabled ? 1231 : 1237);
        result = 31 * result + (this.placementGroup == null ? 0 : this.placementGroup.hashCode());
        result = 31 * result + (this.subnetId == null ? 0 : this.subnetId.hashCode());
        result = 31 * result + (this.userData == null ? 0 : this.userData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EC2TemplateOptions other = (EC2TemplateOptions)((Object)obj);
        if (this.groupIds == null ? other.groupIds != null : !((Object)this.groupIds).equals(other.groupIds)) {
            return false;
        }
        if (this.keyPair == null ? other.keyPair != null : !this.keyPair.equals(other.keyPair)) {
            return false;
        }
        if (this.noKeyPair != other.noKeyPair) {
            return false;
        }
        if (this.noPlacementGroup != other.noPlacementGroup) {
            return false;
        }
        if (this.monitoringEnabled != other.monitoringEnabled) {
            return false;
        }
        if (this.placementGroup == null ? other.placementGroup != null : !this.placementGroup.equals(other.placementGroup)) {
            return false;
        }
        if (this.subnetId == null ? other.subnetId != null : !this.subnetId.equals(other.subnetId)) {
            return false;
        }
        return !(this.userData == null ? other.userData != null : !this.userData.equals(other.userData));
    }

    public String toString() {
        return "[groupIds=" + this.groupIds + ", keyPair=" + this.keyPair + ", noKeyPair=" + this.noKeyPair + ", placementGroup=" + this.placementGroup + ", noPlacementGroup=" + this.noPlacementGroup + ", monitoringEnabled=" + this.monitoringEnabled + ", inboundPorts=" + Arrays.toString(this.inboundPorts) + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", port:seconds=" + this.port + ":" + this.seconds + ", subnetId=" + this.subnetId + ", metadata/details: " + this.includeMetadata + "]";
    }

    public static class Builder {
        public static EC2TemplateOptions securityGroups(String ... groupIds) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.securityGroups(groupIds)));
        }

        public static EC2TemplateOptions securityGroups(Iterable<String> groupIds) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.securityGroups(groupIds)));
        }

        public static EC2TemplateOptions keyPair(String keyPair) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.keyPair(keyPair)));
        }

        public static EC2TemplateOptions userData(byte[] unencodedData) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.userData(unencodedData)));
        }

        public static EC2TemplateOptions noKeyPair() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.noKeyPair()));
        }

        public static EC2TemplateOptions placementGroup(String placementGroup) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.placementGroup(placementGroup)));
        }

        public static EC2TemplateOptions noPlacementGroup() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.noPlacementGroup()));
        }

        public static EC2TemplateOptions enableMonitoring() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.enableMonitoring()));
        }

        public static EC2TemplateOptions inboundPorts(int ... ports) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.inboundPorts(ports)));
        }

        public static EC2TemplateOptions blockOnPort(int port, int seconds) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.blockOnPort(port, seconds)));
        }

        public static EC2TemplateOptions runScript(byte[] script) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.runScript(script)));
        }

        public static EC2TemplateOptions installPrivateKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.installPrivateKey(rsaKey)));
        }

        public static EC2TemplateOptions authorizePublicKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.authorizePublicKey(rsaKey)));
        }

        public static EC2TemplateOptions withDetails() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.withMetadata()));
        }

        public static EC2TemplateOptions subnetId(String subnetId) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast((Object)options.subnetId(subnetId)));
        }
    }
}

