/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ComputationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class EC2TemplateBuilderImpl
extends TemplateBuilderImpl {
    private final Map<RegionAndName, Image> imageMap;
    final Provider<Image> lazyImageProvider = new Provider<Image>(){

        public Image get() {
            if (EC2TemplateBuilderImpl.this.imageId != null) {
                String[] regionName = EC2TemplateBuilderImpl.this.imageId.split("/");
                Preconditions.checkArgument((regionName.length == 2 ? 1 : 0) != 0, (Object)("amazon image ids must include the region ( ex. us-east-1/ami-7ea24a17 ) you specified: " + EC2TemplateBuilderImpl.this.imageId));
                RegionAndName key = new RegionAndName(regionName[0], regionName[1]);
                try {
                    return (Image)EC2TemplateBuilderImpl.this.imageMap.get(key);
                }
                catch (NullPointerException nex) {
                    throw new NoSuchElementException(String.format("image %s/%s not found", key.getRegion(), key.getName()));
                }
                catch (ComputationException nex) {
                    throw new NoSuchElementException(String.format("image %s/%s not found", key.getRegion(), key.getName()));
                }
            }
            return null;
        }
    };

    @Inject
    protected EC2TemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, Supplier<Location> defaultLocation, Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider, Map<RegionAndName, Image> imageMap) {
        super(locations, images, sizes, defaultLocation, optionsProvider, defaultTemplateProvider);
        this.imageMap = imageMap;
    }

    protected void copyTemplateOptions(TemplateOptions from, TemplateOptions to) {
        super.copyTemplateOptions(from, to);
        if (from instanceof EC2TemplateOptions) {
            EC2TemplateOptions eFrom = (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(from));
            EC2TemplateOptions eTo = (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(to));
            if (eFrom.getGroupIds().size() > 0) {
                eTo.securityGroups(eFrom.getGroupIds());
            }
            if (eFrom.getKeyPair() != null) {
                eTo.keyPair(eFrom.getKeyPair());
            }
            if (!eFrom.shouldAutomaticallyCreateKeyPair()) {
                eTo.noKeyPair();
            }
            if (eFrom.getSubnetId() != null) {
                eTo.subnetId(eFrom.getSubnetId());
            }
            if (eFrom.isMonitoringEnabled()) {
                eTo.enableMonitoring();
            }
            if (eFrom.getUserData() != null) {
                eTo.userData(eFrom.getUserData());
            }
        }
    }

    protected Image resolveImage(Hardware size, Iterable<? extends Image> supportedImages) {
        try {
            return super.resolveImage(size, supportedImages);
        }
        catch (NoSuchElementException e) {
            Image returnVal = (Image)this.lazyImageProvider.get();
            if (returnVal != null) {
                return returnVal;
            }
            throw e;
        }
    }

    protected Set<? extends Image> getImages() {
        Image toReturn;
        Set images = (Set)this.images.get();
        if (images.size() == 0 && (toReturn = (Image)this.lazyImageProvider.get()) != null) {
            images.add(toReturn);
        }
        return images;
    }
}

