/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.domain.InstanceState;
import org.jclouds.aws.ec2.domain.RootDeviceType;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.util.Utils;

@Singleton
public class RunningInstanceToNodeMetadata
implements Function<RunningInstance, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Set<? extends Hardware>> hardware;
    protected final Map<RegionAndName, Image> instanceToImage;
    protected final Map<String, Credentials> credentialStore;
    protected final Map<InstanceState, NodeState> instanceToNodeState;

    @Inject
    RunningInstanceToNodeMetadata(Map<InstanceState, NodeState> instanceToNodeState, Map<String, Credentials> credentialStore, Map<RegionAndName, Image> instanceToImage, @Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Hardware>> hardware) {
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.hardware = (Supplier)Preconditions.checkNotNull(hardware, (Object)"hardware");
        this.instanceToImage = (Map)Preconditions.checkNotNull(instanceToImage, (Object)"instanceToImage");
        this.instanceToNodeState = (Map)Preconditions.checkNotNull(instanceToNodeState, (Object)"instanceToNodeState");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    public NodeMetadata apply(RunningInstance instance) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        String providerId = ((RunningInstance)Preconditions.checkNotNull((Object)instance, (Object)"instance")).getId();
        builder.providerId(providerId);
        builder.id(instance.getRegion() + "/" + providerId);
        String tag = this.getTagForInstance(instance);
        builder.tag(tag);
        builder.credentials(this.credentialStore.get("node#" + instance.getRegion() + "/" + providerId));
        builder.state(this.instanceToNodeState.get((Object)instance.getInstanceState()));
        builder.publicAddresses((Iterable)Utils.nullSafeSet((Object)instance.getIpAddress()));
        builder.privateAddresses((Iterable)Utils.nullSafeSet((Object)instance.getPrivateIpAddress()));
        builder.hardware(this.parseHardware(instance));
        Location location = this.getLocationForAvailabilityZoneOrRegion(instance);
        builder.location(location);
        builder.imageId(instance.getRegion() + "/" + instance.getImageId());
        Image image = this.instanceToImage.get(new RegionAndName(instance.getRegion(), instance.getImageId()));
        if (image != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        return builder.build();
    }

    protected Hardware parseHardware(RunningInstance instance) {
        Hardware hardware = this.getHardwareForInstance(instance);
        if (hardware != null) {
            hardware = HardwareBuilder.fromHardware((Hardware)hardware).volumes(RunningInstanceToNodeMetadata.addEBS(instance, hardware.getVolumes())).build();
        }
        return hardware;
    }

    @VisibleForTesting
    static List<Volume> addEBS(final RunningInstance instance, Iterable<? extends Volume> volumes) {
        Iterable ebsVolumes = Iterables.transform(instance.getEbsBlockDevices().entrySet(), (Function)new Function<Map.Entry<String, RunningInstance.EbsBlockDevice>, Volume>(){

            public Volume apply(Map.Entry<String, RunningInstance.EbsBlockDevice> from) {
                return new VolumeImpl(from.getValue().getVolumeId(), Volume.Type.SAN, null, from.getKey(), instance.getRootDeviceName() != null && instance.getRootDeviceName().equals(from.getKey()), true);
            }
        });
        if (instance.getRootDeviceType() == RootDeviceType.EBS) {
            volumes = Iterables.filter(volumes, (Predicate)new Predicate<Volume>(){

                public boolean apply(Volume input) {
                    return !input.isBootDevice();
                }
            });
        }
        return Lists.newArrayList((Iterable)Iterables.concat(volumes, (Iterable)ebsVolumes));
    }

    @VisibleForTesting
    String getTagForInstance(final RunningInstance instance) {
        String tag = String.format("NOTAG-%s", instance.getId());
        try {
            tag = ((String)Iterables.getOnlyElement((Iterable)Iterables.filter(instance.getGroupIds(), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith("jclouds#") && input.endsWith("#" + instance.getRegion());
                }
            }))).substring(8).replaceAll("#" + instance.getRegion() + "$", "");
        }
        catch (NoSuchElementException e) {
            this.logger.debug("no tag parsed from %s's groups: %s", new Object[]{instance.getId(), instance.getGroupIds()});
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("too many groups match %s; %s's groups: %s", new Object[]{"jclouds#", instance.getId(), instance.getGroupIds()});
        }
        return tag;
    }

    @VisibleForTesting
    Hardware getHardwareForInstance(final RunningInstance instance) {
        try {
            return (Hardware)Iterables.find((Iterable)((Iterable)this.hardware.get()), (Predicate)new Predicate<Hardware>(){

                public boolean apply(Hardware input) {
                    return input.getId().equals(instance.getInstanceType());
                }
            });
        }
        catch (NoSuchElementException e) {
            this.logger.debug("couldn't match instance type %s in: %s", new Object[]{instance.getInstanceType(), this.hardware.get()});
            return null;
        }
    }

    private Location getLocationForAvailabilityZoneOrRegion(RunningInstance instance) {
        Location location = this.findLocationWithId(instance.getAvailabilityZone());
        if (location == null) {
            location = this.findLocationWithId(instance.getRegion());
        }
        return location;
    }

    private Location findLocationWithId(final String locationId) {
        try {
            Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }
            });
            return location;
        }
        catch (NoSuchElementException e) {
            this.logger.debug("couldn't match instance location %s in: %s", new Object[]{locationId, this.locations.get()});
            return null;
        }
    }
}

