/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.functions.ImageParser;
import org.jclouds.aws.ec2.domain.Image;
import org.jclouds.aws.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public final class RegionAndIdToImage
implements Function<RegionAndName, org.jclouds.compute.domain.Image> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ImageParser parser;
    private final EC2Client sync;

    @Inject
    public RegionAndIdToImage(ImageParser parser, EC2Client sync) {
        this.parser = parser;
        this.sync = sync;
    }

    public org.jclouds.compute.domain.Image apply(RegionAndName key) {
        try {
            Image image = (Image)Iterables.getOnlyElement(this.sync.getAMIServices().describeImagesInRegion(key.getRegion(), DescribeImagesOptions.Builder.imageIds(key.getName())));
            return this.parser.apply(image);
        }
        catch (ResourceNotFoundException e) {
            this.logger.warn((Throwable)e, "no image found for %s/%s: %s", new Object[]{key.getRegion(), key.getName(), e.getMessage()});
            return null;
        }
    }
}

