/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.Image;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Provider;

@Singleton
public class ImageParser
implements Function<Image, org.jclouds.compute.domain.Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    public static final Pattern NEBULA_PATTERN = Pattern.compile("nebula/(ubuntu-)?(.*)(-.*)?");
    public static final Pattern AMZN_PATTERN = Pattern.compile(".*/amzn-ami-(.*)\\.(i386|x86_64)(-ebs|\\.manifest.xml)?");
    public static final Pattern CANONICAL_PATTERN = Pattern.compile(".*/([^-]*)-([^-]*)-.*-(.*)(\\.manifest.xml)?");
    public static final Pattern RIGHTSCALE_PATTERN = Pattern.compile("[^/]*/([^_]*)_([^_]*)_[^vV]*[vV](.*)(\\.manifest.xml)?");
    public static final Pattern RIGHTIMAGE_PATTERN = Pattern.compile("[^/]*/RightImage[_ ]([^_]*)_([^_]*)_[^vV]*[vV](.*)(\\.manifest.xml)?");
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialProvider;
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Location> defaultLocation;
    private final String provider;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    ImageParser(PopulateDefaultLoginCredentialsForImageStrategy credentialProvider, Map<OsFamily, Map<String, String>> osVersionMap, @Memoized Supplier<Set<? extends Location>> locations, Supplier<Location> defaultLocation, @Provider String provider) {
        this.credentialProvider = (PopulateDefaultLoginCredentialsForImageStrategy)Preconditions.checkNotNull((Object)credentialProvider, (Object)"credentialProvider");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.provider = (String)Preconditions.checkNotNull((Object)provider, (Object)"provider");
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"utils");
    }

    public org.jclouds.compute.domain.Image apply(final Image from) {
        if (from.getImageType() != Image.ImageType.MACHINE) {
            this.logger.trace("skipping as not a machine image(%s)", new Object[]{from.getId()});
            return null;
        }
        ImageBuilder builder = new ImageBuilder();
        builder.providerId(from.getId());
        builder.id(from.getRegion() + "/" + from.getId());
        builder.description(from.getDescription() != null ? from.getDescription() : from.getImageLocation());
        builder.userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)from.getImageOwnerId(), (Object)"rootDeviceType", (Object)from.getRootDeviceType().toString()));
        OsFamily osFamily = ComputeServiceUtils.parseOsFamilyOrNull((String)this.provider, (String)from.getImageLocation());
        String osName = null;
        String osArch = from.getVirtualizationType();
        String osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)from.getImageLocation(), this.osVersionMap);
        String osDescription = from.getImageLocation();
        boolean is64Bit = from.getArchitecture() == Image.Architecture.X86_64;
        try {
            Matcher matcher = this.getMatcherAndFind(from.getImageLocation());
            if (matcher.pattern() == AMZN_PATTERN) {
                osFamily = OsFamily.AMZN_LINUX;
                osVersion = matcher.group(1);
                builder.version(osVersion);
            } else if (matcher.pattern() == NEBULA_PATTERN) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(2), this.osVersionMap);
            } else {
                osFamily = OsFamily.fromValue((String)matcher.group(1));
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(2), this.osVersionMap);
                builder.version(matcher.group(3).replace(".manifest.xml", ""));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("<< didn't match os(%s)", new Object[]{from.getImageLocation()});
        }
        catch (NoSuchElementException e) {
            this.logger.debug("<< didn't match at all(%s)", new Object[]{from.getImageLocation()});
        }
        builder.defaultCredentials(this.credentialProvider.execute((Object)from));
        try {
            builder.location((Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(from.getRegion());
                }
            }));
        }
        catch (NoSuchElementException e) {
            System.err.printf("unknown region %s for image %s; not in %s", from.getRegion(), from.getId(), this.locations);
            builder.location((Location)new LocationImpl(LocationScope.REGION, from.getRegion(), from.getRegion(), ((Location)this.defaultLocation.get()).getParent()));
        }
        builder.operatingSystem(new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit));
        return builder.build();
    }

    private Matcher getMatcherAndFind(String manifest) {
        for (Pattern pattern : new Pattern[]{AMZN_PATTERN, NEBULA_PATTERN, CANONICAL_PATTERN, RIGHTIMAGE_PATTERN, RIGHTSCALE_PATTERN}) {
            Matcher matcher = pattern.matcher(manifest);
            if (!matcher.find()) continue;
            return matcher;
        }
        throw new NoSuchElementException(manifest);
    }
}

