/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;

@Singleton
public class CredentialsForInstance
implements Function<RunningInstance, Credentials> {
    private final Map<RegionAndName, KeyPair> credentialsMap;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialProvider;
    private final Map<RegionAndName, Image> imageForInstance;

    @Inject
    CredentialsForInstance(Map<RegionAndName, KeyPair> credentialsMap, PopulateDefaultLoginCredentialsForImageStrategy credentialProvider, Map<RegionAndName, Image> imageForInstance) {
        this.credentialsMap = (Map)Preconditions.checkNotNull(credentialsMap, (Object)"credentialsMap");
        this.credentialProvider = (PopulateDefaultLoginCredentialsForImageStrategy)Preconditions.checkNotNull((Object)credentialProvider, (Object)"credentialProvider");
        this.imageForInstance = imageForInstance;
    }

    public Credentials apply(RunningInstance instance) {
        Credentials credentials = null;
        if (instance.getKeyName() != null) {
            credentials = new Credentials(this.getLoginAccountFor(instance), this.getPrivateKeyOrNull(instance));
        }
        return credentials;
    }

    @VisibleForTesting
    String getPrivateKeyOrNull(RunningInstance instance) {
        KeyPair keyPair = this.credentialsMap.get(new RegionAndName(instance.getRegion(), instance.getKeyName()));
        return keyPair != null ? keyPair.getKeyMaterial() : null;
    }

    @VisibleForTesting
    String getLoginAccountFor(RunningInstance from) {
        return ((Credentials)Preconditions.checkNotNull((Object)this.credentialProvider.execute((Object)this.imageForInstance.get((Object)new RegionAndName((String)from.getRegion(), (String)from.getImageId()))), (Object)new StringBuilder().append((String)"login from image: ").append((String)from.getImageId()).toString())).identity;
    }
}

