/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.logging.Logger;

@Singleton
public class CreateUniqueKeyPair
implements Function<RegionAndName, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Client ec2Client;
    protected Supplier<String> randomSuffix;

    @Inject
    public CreateUniqueKeyPair(EC2Client ec2Client, Supplier<String> randomSuffix) {
        this.ec2Client = ec2Client;
        this.randomSuffix = randomSuffix;
    }

    public KeyPair apply(RegionAndName from) {
        return this.createNewKeyPairInRegion(from.getRegion(), from.getName());
    }

    @VisibleForTesting
    KeyPair createNewKeyPairInRegion(String region, String tag) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)tag, (Object)"tag");
        this.logger.debug(">> creating keyPair region(%s) tag(%s)", new Object[]{region, tag});
        KeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = this.ec2Client.getKeyPairServices().createKeyPairInRegion(region, this.getNextName(region, tag));
                this.logger.debug("<< created keyPair(%s)", new Object[]{keyPair.getKeyName()});
            }
            catch (IllegalStateException e) {}
        }
        return keyPair;
    }

    private String getNextName(String region, String tag) {
        return String.format("jclouds#%s#%s#%s", tag, region, this.randomSuffix.get());
    }
}

