/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.aws.ec2.domain.IpProtocol;
import org.jclouds.aws.ec2.domain.SecurityGroup;
import org.jclouds.aws.ec2.domain.UserIdGroupPair;
import org.jclouds.logging.Logger;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<RegionNameAndIngressRules, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Client ec2Client;

    @Inject
    public CreateSecurityGroupIfNeeded(EC2Client ec2Client) {
        this.ec2Client = ec2Client;
    }

    public String apply(RegionNameAndIngressRules from) {
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), from.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", new Object[]{region, name});
        try {
            this.ec2Client.getSecurityGroupServices().createSecurityGroupInRegion(region, name, name);
            this.logger.debug("<< created securityGroup(%s)", new Object[]{name});
            for (int port : ports) {
                this.createIngressRuleForTCPPort(region, name, port);
            }
            if (ports.length > 0) {
                this.authorizeGroupToItself(region, name);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{name});
        }
    }

    private void createIngressRuleForTCPPort(String region, String name, int port) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) port(%s)", new Object[]{region, name, port});
        this.ec2Client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(region, name, IpProtocol.TCP, port, port, "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
    }

    private void authorizeGroupToItself(String region, String name) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) permission to itself", new Object[]{region, name});
        String myOwnerId = ((SecurityGroup)Iterables.get(this.ec2Client.getSecurityGroupServices().describeSecurityGroupsInRegion(region, new String[0]), (int)0)).getOwnerId();
        this.ec2Client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(myOwnerId, name));
        this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
    }
}

