/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.logging.Logger;

@Singleton
public class CreatePlacementGroupIfNeeded
implements Function<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Client ec2Client;
    protected final Predicate<PlacementGroup> placementGroupAvailable;

    @Inject
    public CreatePlacementGroupIfNeeded(EC2Client ec2Client, @Named(value="AVAILABLE") Predicate<PlacementGroup> placementGroupAvailable) {
        this.ec2Client = ec2Client;
        this.placementGroupAvailable = placementGroupAvailable;
    }

    public String apply(RegionAndName from) {
        this.createPlacementGroupInRegion(from.getRegion(), from.getName());
        return from.getName();
    }

    private void createPlacementGroupInRegion(String region, String name) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.logger.debug(">> creating placementGroup region(%s) name(%s)", new Object[]{region, name});
        try {
            this.ec2Client.getPlacementGroupServices().createPlacementGroupInRegion(region, name);
            this.logger.debug("<< created placementGroup(%s)", new Object[]{name});
            Preconditions.checkState((boolean)this.placementGroupAvailable.apply((Object)new PlacementGroup(region, name, "cluster", PlacementGroup.State.PENDING)), (Object)String.format("placementGroup region(%s) name(%s) failed to become available", region, name));
        }
        catch (AWSResponseException e) {
            if (e.getError().getCode().equals("InvalidPlacementGroup.Duplicate")) {
                this.logger.debug("<< reused placementGroup(%s)", new Object[]{name});
            }
            throw e;
        }
    }
}

