/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jclouds.aws.ec2.domain.RootDeviceType;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;

public class EC2HardwareBuilder
extends HardwareBuilder {
    public EC2HardwareBuilder(String instanceType) {
        this.ids(instanceType);
    }

    public EC2HardwareBuilder rootDeviceType(RootDeviceType rootDeviceType) {
        this.supportsImage(new HasRootDeviceType(rootDeviceType));
        return this;
    }

    public EC2HardwareBuilder supportsImageIds(String ... ids) {
        Preconditions.checkArgument((ids != null && ids.length > 0 ? 1 : 0) != 0, (Object)"ids must be specified");
        this.supportsImage(ImagePredicates.idIn(Arrays.asList(ids)));
        return this;
    }

    public EC2HardwareBuilder ids(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ids(id)));
    }

    public EC2HardwareBuilder ram(int ram) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ram(ram)));
    }

    public EC2HardwareBuilder processors(List<Processor> processors) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.processors(processors)));
    }

    public EC2HardwareBuilder volumes(List<Volume> volumes) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.volumes(volumes)));
    }

    public EC2HardwareBuilder supportsImage(Predicate<Image> supportsImage) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.supportsImage(supportsImage)));
    }

    public EC2HardwareBuilder is64Bit(boolean is64Bit) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.is64Bit(is64Bit)));
    }

    public EC2HardwareBuilder id(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.id(id)));
    }

    public EC2HardwareBuilder providerId(String providerId) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.providerId(providerId)));
    }

    public EC2HardwareBuilder name(String name) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.name(name)));
    }

    public EC2HardwareBuilder location(Location location) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.location(location)));
    }

    public EC2HardwareBuilder uri(URI uri) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.uri(uri)));
    }

    public EC2HardwareBuilder userMetadata(Map<String, String> userMetadata) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.userMetadata(userMetadata)));
    }

    public static EC2HardwareBuilder m1_small() {
        return new EC2HardwareBuilder("m1.small").ram(1740).processors((List)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(150.0f), "/dev/sda2", false, false))).is64Bit(false);
    }

    public static EC2HardwareBuilder t1_micro() {
        return new EC2HardwareBuilder("t1.micro").ram(630).processors((List)ImmutableList.of((Object)new Processor(1.0, 1.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m1_large() {
        return new EC2HardwareBuilder("m1.large").ram(7680).processors((List)ImmutableList.of((Object)new Processor(2.0, 2.0))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdb", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdc", false, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder m1_xlarge() {
        return new EC2HardwareBuilder("m1.xlarge").ram(15360).processors((List)ImmutableList.of((Object)new Processor(4.0, 2.0))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdb", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdc", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdd", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sde", false, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_xlarge() {
        return new EC2HardwareBuilder("m2.xlarge").ram(17510).processors((List)ImmutableList.of((Object)new Processor(2.0, 3.25))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sda1", true, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_2xlarge() {
        return new EC2HardwareBuilder("m2.2xlarge").ram(35020).processors((List)ImmutableList.of((Object)new Processor(4.0, 3.25))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(840.0f), "/dev/sdb", false, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_4xlarge() {
        return new EC2HardwareBuilder("m2.4xlarge").ram(70041).processors((List)ImmutableList.of((Object)new Processor(8.0, 3.25))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(840.0f), "/dev/sdb", false, false), (Object)new VolumeImpl(Float.valueOf(840.0f), "/dev/sdc", false, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder c1_medium() {
        return new EC2HardwareBuilder("c1.medium").ram(1740).processors((List)ImmutableList.of((Object)new Processor(2.0, 2.5))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(340.0f), "/dev/sda2", false, false))).is64Bit(false);
    }

    public static EC2HardwareBuilder c1_xlarge() {
        return new EC2HardwareBuilder("c1.xlarge").ram(7168).processors((List)ImmutableList.of((Object)new Processor(8.0, 2.5))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdb", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdc", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sdd", false, false), (Object)new VolumeImpl(Float.valueOf(420.0f), "/dev/sde", false, false))).is64Bit(true);
    }

    public static EC2HardwareBuilder cc1_4xlarge() {
        return new EC2HardwareBuilder("cc1.4xlarge").ram(23552).processors((List)ImmutableList.of((Object)new Processor(4.0, 4.0), (Object)new Processor(4.0, 4.0))).volumes((List)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), "/dev/sda1", true, false), (Object)new VolumeImpl(Float.valueOf(840.0f), "/dev/sdb", false, false), (Object)new VolumeImpl(Float.valueOf(840.0f), "/dev/sdc", false, false)));
    }

    public static class HasRootDeviceType
    implements Predicate<Image> {
        final RootDeviceType type;

        public HasRootDeviceType(RootDeviceType type) {
            this.type = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must be defined"));
        }

        public boolean apply(Image image) {
            return this.type.toString().equals(image.getUserMetadata().get("rootDeviceType"));
        }

        public String toString() {
            return "hasRootDeviceType(" + (Object)((Object)this.type) + ")";
        }
    }
}

