/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.EC2AsyncClient;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.EC2ComputeService;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.aws.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.aws.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.aws.ec2.compute.functions.RegionAndIdToImage;
import org.jclouds.aws.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.aws.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.aws.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.aws.ec2.domain.InstanceState;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.predicates.InstancePresent;
import org.jclouds.aws.ec2.predicates.PlacementGroupAvailable;
import org.jclouds.aws.ec2.predicates.PlacementGroupDeleted;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.RestContextImpl;

public class EC2ComputeServiceDependenciesModule
extends AbstractModule {
    public static final Map<InstanceState, NodeState> instanceToNodeState = ImmutableMap.builder().put((Object)InstanceState.PENDING, (Object)NodeState.PENDING).put((Object)InstanceState.RUNNING, (Object)NodeState.RUNNING).put((Object)InstanceState.SHUTTING_DOWN, (Object)NodeState.PENDING).put((Object)InstanceState.TERMINATED, (Object)NodeState.TERMINATED).put((Object)InstanceState.STOPPING, (Object)NodeState.PENDING).put((Object)InstanceState.STOPPED, (Object)NodeState.SUSPENDED).put((Object)InstanceState.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).build();

    @Singleton
    @Provides
    Map<InstanceState, NodeState> provideServerToNodeState() {
        return instanceToNodeState;
    }

    @Provides
    @Singleton
    @Named(value="PRESENT")
    protected Predicate<RunningInstance> instancePresent(InstancePresent present) {
        return new RetryablePredicate((Predicate)present, 5000L, 200L, TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    @Named(value="AVAILABLE")
    protected Predicate<PlacementGroup> placementGroupAvailable(PlacementGroupAvailable available) {
        return new RetryablePredicate((Predicate)available, 60L, 1L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="DELETED")
    protected Predicate<PlacementGroup> placementGroupDeleted(PlacementGroupDeleted deleted) {
        return new RetryablePredicate((Predicate)deleted, 60L, 1L, TimeUnit.SECONDS);
    }

    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(EC2TemplateOptions.class);
        this.bind(ComputeService.class).to(EC2ComputeService.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RunningInstance, NodeMetadata>>(){}).to(RunningInstanceToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RunningInstance, Credentials>>(){}).to(CredentialsForInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<EC2Client, EC2AsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<RestContext<EC2Client, EC2AsyncClient>>(){}).to((TypeLiteral)new TypeLiteral<RestContextImpl<EC2Client, EC2AsyncClient>>(){}).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    Supplier<String> provideSuffix() {
        return new Supplier<String>(){
            final SecureRandom random = new SecureRandom();

            public String get() {
                return this.random.nextInt(100) + "";
            }
        };
    }

    @Provides
    @Singleton
    protected final Map<RegionAndName, KeyPair> credentialsMap(CreateUniqueKeyPair in) {
        return Maps.newLinkedHashMap();
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected final Map<RegionAndName, String> securityGroupMap(CreateSecurityGroupIfNeeded in) {
        return Maps.newLinkedHashMap();
    }

    @Provides
    @Singleton
    @Named(value="PLACEMENT")
    protected final Map<RegionAndName, String> placementGroupMap(CreatePlacementGroupIfNeeded in) {
        return Maps.newLinkedHashMap();
    }

    @Provides
    @Singleton
    @Named(value="jclouds.ec2.ami-owners")
    String[] amiOwners(@Named(value="jclouds.ec2.ami-owners") String amiOwners) {
        if (amiOwners.trim().equals("")) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)',').split((CharSequence)amiOwners), String.class);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.ec2.cc-amis")
    String[] ccAmis(@Named(value="jclouds.ec2.cc-amis") String ccAmis) {
        if (ccAmis.trim().equals("")) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)',').split((CharSequence)ccAmis), String.class);
    }

    @Provides
    @Singleton
    protected Map<RegionAndName, Image> provideImageMap(RegionAndIdToImage regionAndIdToImage) {
        return new MapMaker().makeComputingMap((Function)regionAndIdToImage);
    }
}

