/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Supplier;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.EC2BindComputeStrategiesByClass;
import org.jclouds.aws.ec2.compute.config.EC2BindComputeSuppliersByClass;
import org.jclouds.aws.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.strategy.EC2DestroyLoadBalancerStrategy;
import org.jclouds.aws.ec2.compute.strategy.EC2LoadBalanceNodesStrategy;
import org.jclouds.aws.ec2.compute.suppliers.RegionAndNameToImageSupplier;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.compute.strategy.LoadBalanceNodesStrategy;
import org.jclouds.rest.annotations.Provider;
import org.jclouds.rest.suppliers.RetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

public class EC2ComputeServiceContextModule
extends BaseComputeServiceContextModule {
    protected void configure() {
        this.install((Module)new EC2ComputeServiceDependenciesModule());
        this.install((Module)new EC2BindComputeStrategiesByClass());
        this.install((Module)new EC2BindComputeSuppliersByClass());
        super.configure();
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        String provider = (String)injector.getInstance(Key.get(String.class, Provider.class));
        if ("ec2".equals(provider)) {
            return template.osFamily(OsFamily.AMZN_LINUX).os64Bit(true);
        }
        if ("nova".equals(provider)) {
            return super.provideTemplate(injector, template);
        }
        return template.osFamily(OsFamily.CENTOS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<RegionAndName, ? extends Image>> provideRegionAndNameToImageSupplierCache(@Named(value="jclouds.session-interval") long seconds, final RegionAndNameToImageSupplier supplier) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Map<RegionAndName, ? extends Image>>(){

            public Map<RegionAndName, ? extends Image> get() {
                return supplier.get();
            }
        });
    }

    protected void bindLoadBalancerService() {
        this.bind(LoadBalanceNodesStrategy.class).to(EC2LoadBalanceNodesStrategy.class);
        this.bind(DestroyLoadBalancerStrategy.class).to(EC2DestroyLoadBalancerStrategy.class);
    }
}

