/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.domain.RegionAndName;
import org.jclouds.aws.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.aws.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.RunNodesAndAddToSetStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpResponseException;
import org.jclouds.util.Utils;

@Singleton
public class EC2ComputeService
extends BaseComputeService {
    private final EC2Client ec2Client;
    private final Map<RegionAndName, KeyPair> credentialsMap;
    private final Map<RegionAndName, String> securityGroupMap;
    private final Map<RegionAndName, String> placementGroupMap;
    private final Predicate<PlacementGroup> placementGroupDeleted;

    @Inject
    protected EC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, RunNodesAndAddToSetStrategy runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, Provider<TemplateOptions> templateOptionsProvider, @Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, @Named(value="NODE_TERMINATED") Predicate<NodeMetadata> nodeTerminated, @Named(value="NODE_SUSPENDED") Predicate<NodeMetadata> nodeSuspended, ComputeUtils utils, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, EC2Client ec2Client, Map<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") Map<RegionAndName, String> securityGroupMap, @Named(value="PLACEMENT") Map<RegionAndName, String> placementGroupMap, @Named(value="DELETED") Predicate<PlacementGroup> placementGroupDeleted) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, utils, timeouts, executor);
        this.ec2Client = ec2Client;
        this.credentialsMap = credentialsMap;
        this.securityGroupMap = securityGroupMap;
        this.placementGroupMap = placementGroupMap;
        this.placementGroupDeleted = placementGroupDeleted;
    }

    @VisibleForTesting
    void deletePlacementGroup(String region, String tag) {
        block5: {
            Utils.checkNotEmpty((String)tag, (String)"tag");
            String group = String.format("jclouds#%s#%s", tag, region);
            try {
                if (this.ec2Client.getPlacementGroupServices().describePlacementGroupsInRegion(region, group).size() <= 0) break block5;
                this.logger.debug(">> deleting placementGroup(%s)", new Object[]{group});
                try {
                    this.ec2Client.getPlacementGroupServices().deletePlacementGroupInRegion(region, group);
                    Preconditions.checkState((boolean)this.placementGroupDeleted.apply((Object)new PlacementGroup(region, group, "cluster", PlacementGroup.State.PENDING)), (Object)String.format("placementGroup region(%s) name(%s) failed to delete", region, group));
                    this.placementGroupMap.remove(new RegionAndName(region, tag));
                    this.logger.debug("<< deleted placementGroup(%s)", new Object[]{group});
                }
                catch (AWSResponseException e) {
                    if (e.getError().getCode().equals("InvalidPlacementGroup.InUse")) {
                        this.logger.debug("<< inUse placementGroup(%s)", new Object[]{group});
                        break block5;
                    }
                    throw e;
                }
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 400 && this.context.getProviderSpecificContext().getProvider().equals("eucalyptus")) break block5;
                throw e;
            }
        }
    }

    @VisibleForTesting
    void deleteSecurityGroup(String region, String tag) {
        Utils.checkNotEmpty((String)tag, (String)"tag");
        String group = String.format("jclouds#%s#%s", tag, region);
        if (this.ec2Client.getSecurityGroupServices().describeSecurityGroupsInRegion(region, group).size() > 0) {
            this.logger.debug(">> deleting securityGroup(%s)", new Object[]{group});
            this.ec2Client.getSecurityGroupServices().deleteSecurityGroupInRegion(region, group);
            this.securityGroupMap.remove(new RegionNameAndIngressRules(region, tag, null, false));
            this.logger.debug("<< deleted securityGroup(%s)", new Object[]{group});
        }
    }

    @VisibleForTesting
    void deleteKeyPair(String region, String tag) {
        for (KeyPair keyPair : this.ec2Client.getKeyPairServices().describeKeyPairsInRegion(region, new String[0])) {
            if (!keyPair.getKeyName().matches(String.format("jclouds#%s#%s#%s", tag, region, "[0-9a-f]+"))) continue;
            this.logger.debug(">> deleting keyPair(%s)", new Object[]{keyPair.getKeyName()});
            this.ec2Client.getKeyPairServices().deleteKeyPairInRegion(region, keyPair.getKeyName());
            this.credentialsMap.remove(new RegionAndName(region, keyPair.getKeyName()));
            this.logger.debug("<< deleted keyPair(%s)", new Object[]{keyPair.getKeyName()});
        }
    }

    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        Set deadOnes = super.destroyNodesMatching(filter);
        HashMap regionTags = Maps.newHashMap();
        for (NodeMetadata nodeMetadata : deadOnes) {
            if (nodeMetadata.getTag() == null) continue;
            regionTags.put(EC2Utils.parseHandle(nodeMetadata.getId())[0], nodeMetadata.getTag());
        }
        for (Map.Entry entry : regionTags.entrySet()) {
            this.deleteKeyPair((String)entry.getKey(), (String)entry.getValue());
            this.deleteSecurityGroup((String)entry.getKey(), (String)entry.getValue());
            this.deletePlacementGroup((String)entry.getKey(), (String)entry.getValue());
        }
        return deadOnes;
    }

    public EC2TemplateOptions templateOptions() {
        return (EC2TemplateOptions)((Object)EC2TemplateOptions.class.cast(super.templateOptions()));
    }
}

