/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserGroupsToIndexedFormParams
implements Binder {
    public void bindToRequest(HttpRequest request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)("this binder is only valid for Iterable<?>: " + input.getClass()));
        this.checkValidUserGroup(input);
        EC2Utils.indexIterableToFormValuesWithPrefix(request, "UserGroup", input);
    }

    private void checkValidUserGroup(Object input) {
        Iterable values = (Iterable)input;
        long size = Iterables.size((Iterable)values);
        Preconditions.checkArgument((size == 0L || size == 1L && Iterables.getOnlyElement((Iterable)values).equals("all") ? 1 : 0) != 0, (Object)"only supported UserGroup is 'all'");
    }
}

