/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Binder;

@Singleton
public class BindS3UploadPolicyAndSignature
implements Binder {
    private final FormSigner signer;

    @Inject
    BindS3UploadPolicyAndSignature(FormSigner signer, Crypto crypto) {
        this.signer = signer;
    }

    public void bindToRequest(HttpRequest request, Object input) {
        String encodedJson = CryptoStreams.base64((byte[])Preconditions.checkNotNull((Object)input, (Object)"json").toString().getBytes(Charsets.UTF_8));
        HttpUtils.addFormParamTo((HttpRequest)request, (String)"Storage.S3.UploadPolicy", (String)encodedJson);
        String signature = this.signer.sign(encodedJson);
        HttpUtils.addFormParamTo((HttpRequest)request, (String)"Storage.S3.UploadPolicySignature", (String)signature);
    }
}

