/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Preconditions;
import org.jclouds.aws.ec2.domain.BlockDeviceMapping;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Binder;

public class BindBlockDeviceMappingToIndexedFormParams
implements Binder {
    private final String deviceNamePattern = "BlockDeviceMapping.%d.DeviceName";
    private final String volumeIdPattern = "BlockDeviceMapping.%d.Ebs.VolumeId";
    private final String deleteOnTerminationPattern = "BlockDeviceMapping.%d.Ebs.DeleteOnTermination";

    public void bindToRequest(HttpRequest request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof BlockDeviceMapping), (Object)"this binder is only valid for BlockDeviceMapping");
        BlockDeviceMapping blockDeviceMapping = (BlockDeviceMapping)input;
        int amazonOneBasedIndex = 1;
        for (String ebsBlockDeviceName : blockDeviceMapping.getEbsBlockDevices().keySet()) {
            for (RunningInstance.EbsBlockDevice ebsBlockDevice : blockDeviceMapping.getEbsBlockDevices().get((Object)ebsBlockDeviceName)) {
                HttpUtils.addFormParamTo((HttpRequest)request, (String)String.format("BlockDeviceMapping.%d.Ebs.VolumeId", amazonOneBasedIndex), (String)ebsBlockDevice.getVolumeId());
                if (ebsBlockDeviceName != null) {
                    HttpUtils.addFormParamTo((HttpRequest)request, (String)String.format("BlockDeviceMapping.%d.DeviceName", amazonOneBasedIndex), (String)ebsBlockDeviceName);
                }
                HttpUtils.addFormParamTo((HttpRequest)request, (String)String.format("BlockDeviceMapping.%d.Ebs.DeleteOnTermination", amazonOneBasedIndex), (String)String.valueOf(ebsBlockDevice.isDeleteOnTermination()));
                ++amazonOneBasedIndex;
            }
        }
    }
}

